/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.PermissionType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=96")
public class RolePermissionType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.RolePermissionType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.RolePermissionType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.RolePermissionType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.RolePermissionType;
    public static final StructureSpecification SPECIFICATION;
    private NodeId roleId;
    private PermissionType permissions;

    public RolePermissionType() {
    }

    public RolePermissionType(NodeId nodeId, PermissionType permissionType) {
        this.roleId = nodeId;
        this.permissions = permissionType;
    }

    public NodeId getRoleId() {
        return this.roleId;
    }

    public void setRoleId(NodeId nodeId) {
        this.roleId = nodeId;
    }

    public PermissionType getPermissions() {
        return this.permissions;
    }

    public void setPermissions(PermissionType permissionType) {
        this.permissions = permissionType;
    }

    @Override
    public RolePermissionType clone() {
        RolePermissionType rolePermissionType = (RolePermissionType)super.clone();
        rolePermissionType.roleId = StructureUtils.clone(this.roleId);
        rolePermissionType.permissions = StructureUtils.clone(this.permissions);
        return rolePermissionType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RolePermissionType rolePermissionType = (RolePermissionType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRoleId(), rolePermissionType.getRoleId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getPermissions(), rolePermissionType.getPermissions());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRoleId(), this.getPermissions());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RoleId.getSpecification().equals(fieldSpecification)) {
            return this.getRoleId();
        }
        if (Fields.Permissions.getSpecification().equals(fieldSpecification)) {
            return this.getPermissions();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RoleId.getSpecification().equals(fieldSpecification)) {
            this.setRoleId((NodeId)object);
            return;
        }
        if (Fields.Permissions.getSpecification().equals(fieldSpecification)) {
            this.setPermissions((PermissionType)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = RolePermissionType.builder();
        builder.setRoleId(this.getRoleId());
        builder.setPermissions(this.getPermissions());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RoleId.getSpecification());
        builder.addField(Fields.Permissions.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("RolePermissionType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.RolePermissionTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return RolePermissionType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId roleId;
        private PermissionType permissions;

        protected Builder() {
        }

        public Builder setRoleId(NodeId nodeId) {
            this.roleId = nodeId;
            return this;
        }

        public Builder setPermissions(PermissionType permissionType) {
            this.permissions = permissionType;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RoleId.getSpecification().equals(fieldSpecification)) {
                this.setRoleId((NodeId)object);
                return this;
            }
            if (Fields.Permissions.getSpecification().equals(fieldSpecification)) {
                this.setPermissions((PermissionType)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public RolePermissionType build() {
            return new RolePermissionType(this.roleId, this.permissions);
        }
    }

    public static enum Fields {
        RoleId("RoleId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        Permissions("Permissions", PermissionType.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=94")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

