/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.RepublishResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=830")
public class RepublishRequest
extends AbstractStructure
implements ServiceRequest<RepublishResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.RepublishRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.RepublishRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.RepublishRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.RepublishRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private UnsignedInteger subscriptionId;
    private UnsignedInteger retransmitSequenceNumber;

    public RepublishRequest() {
    }

    public RepublishRequest(RequestHeader requestHeader, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) {
        this.requestHeader = requestHeader;
        this.subscriptionId = unsignedInteger;
        this.retransmitSequenceNumber = unsignedInteger2;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public UnsignedInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(UnsignedInteger unsignedInteger) {
        this.subscriptionId = unsignedInteger;
    }

    public UnsignedInteger getRetransmitSequenceNumber() {
        return this.retransmitSequenceNumber;
    }

    public void setRetransmitSequenceNumber(UnsignedInteger unsignedInteger) {
        this.retransmitSequenceNumber = unsignedInteger;
    }

    @Override
    public RepublishRequest clone() {
        RepublishRequest republishRequest = (RepublishRequest)super.clone();
        republishRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        republishRequest.subscriptionId = StructureUtils.clone(this.subscriptionId);
        republishRequest.retransmitSequenceNumber = StructureUtils.clone(this.retransmitSequenceNumber);
        return republishRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RepublishRequest republishRequest = (RepublishRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), republishRequest.getRequestHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSubscriptionId(), republishRequest.getSubscriptionId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getRetransmitSequenceNumber(), republishRequest.getRetransmitSequenceNumber());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getSubscriptionId(), this.getRetransmitSequenceNumber());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.SubscriptionId.getSpecification().equals(fieldSpecification)) {
            return this.getSubscriptionId();
        }
        if (Fields.RetransmitSequenceNumber.getSpecification().equals(fieldSpecification)) {
            return this.getRetransmitSequenceNumber();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.SubscriptionId.getSpecification().equals(fieldSpecification)) {
            this.setSubscriptionId((UnsignedInteger)object);
            return;
        }
        if (Fields.RetransmitSequenceNumber.getSpecification().equals(fieldSpecification)) {
            this.setRetransmitSequenceNumber((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = RepublishRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setSubscriptionId(this.getSubscriptionId());
        builder.setRetransmitSequenceNumber(this.getRetransmitSequenceNumber());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.SubscriptionId.getSpecification());
        builder.addField(Fields.RetransmitSequenceNumber.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("RepublishRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.RepublishRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return RepublishRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private UnsignedInteger subscriptionId;
        private UnsignedInteger retransmitSequenceNumber;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setSubscriptionId(UnsignedInteger unsignedInteger) {
            this.subscriptionId = unsignedInteger;
            return this;
        }

        public Builder setRetransmitSequenceNumber(UnsignedInteger unsignedInteger) {
            this.retransmitSequenceNumber = unsignedInteger;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.SubscriptionId.getSpecification().equals(fieldSpecification)) {
                this.setSubscriptionId((UnsignedInteger)object);
                return this;
            }
            if (Fields.RetransmitSequenceNumber.getSpecification().equals(fieldSpecification)) {
                this.setRetransmitSequenceNumber((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public RepublishRequest build() {
            return new RepublishRequest(this.requestHeader, this.subscriptionId, this.retransmitSequenceNumber);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        SubscriptionId("SubscriptionId", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=288")), -1),
        RetransmitSequenceNumber("RetransmitSequenceNumber", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=289")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

