/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=537")
public class RelativePathElement
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.RelativePathElement_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.RelativePathElement_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.RelativePathElement_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.RelativePathElement;
    public static final StructureSpecification SPECIFICATION;
    private NodeId referenceTypeId;
    private Boolean isInverse;
    private Boolean includeSubtypes;
    private QualifiedName targetName;

    public RelativePathElement() {
    }

    public RelativePathElement(NodeId nodeId, Boolean bl, Boolean bl2, QualifiedName qualifiedName) {
        this.referenceTypeId = nodeId;
        this.isInverse = bl;
        this.includeSubtypes = bl2;
        this.targetName = qualifiedName;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public void setReferenceTypeId(NodeId nodeId) {
        this.referenceTypeId = nodeId;
    }

    public Boolean getIsInverse() {
        return this.isInverse;
    }

    public void setIsInverse(Boolean bl) {
        this.isInverse = bl;
    }

    public Boolean getIncludeSubtypes() {
        return this.includeSubtypes;
    }

    public void setIncludeSubtypes(Boolean bl) {
        this.includeSubtypes = bl;
    }

    public QualifiedName getTargetName() {
        return this.targetName;
    }

    public void setTargetName(QualifiedName qualifiedName) {
        this.targetName = qualifiedName;
    }

    @Override
    public RelativePathElement clone() {
        RelativePathElement relativePathElement = (RelativePathElement)super.clone();
        relativePathElement.referenceTypeId = StructureUtils.clone(this.referenceTypeId);
        relativePathElement.isInverse = StructureUtils.clone(this.isInverse);
        relativePathElement.includeSubtypes = StructureUtils.clone(this.includeSubtypes);
        relativePathElement.targetName = StructureUtils.clone(this.targetName);
        return relativePathElement;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelativePathElement relativePathElement = (RelativePathElement)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getReferenceTypeId(), relativePathElement.getReferenceTypeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIsInverse(), relativePathElement.getIsInverse())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIncludeSubtypes(), relativePathElement.getIncludeSubtypes())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getTargetName(), relativePathElement.getTargetName());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getReferenceTypeId(), this.getIsInverse(), this.getIncludeSubtypes(), this.getTargetName());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ReferenceTypeId.getSpecification().equals(fieldSpecification)) {
            return this.getReferenceTypeId();
        }
        if (Fields.IsInverse.getSpecification().equals(fieldSpecification)) {
            return this.getIsInverse();
        }
        if (Fields.IncludeSubtypes.getSpecification().equals(fieldSpecification)) {
            return this.getIncludeSubtypes();
        }
        if (Fields.TargetName.getSpecification().equals(fieldSpecification)) {
            return this.getTargetName();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ReferenceTypeId.getSpecification().equals(fieldSpecification)) {
            this.setReferenceTypeId((NodeId)object);
            return;
        }
        if (Fields.IsInverse.getSpecification().equals(fieldSpecification)) {
            this.setIsInverse((Boolean)object);
            return;
        }
        if (Fields.IncludeSubtypes.getSpecification().equals(fieldSpecification)) {
            this.setIncludeSubtypes((Boolean)object);
            return;
        }
        if (Fields.TargetName.getSpecification().equals(fieldSpecification)) {
            this.setTargetName((QualifiedName)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = RelativePathElement.builder();
        builder.setReferenceTypeId(this.getReferenceTypeId());
        builder.setIsInverse(this.getIsInverse());
        builder.setIncludeSubtypes(this.getIncludeSubtypes());
        builder.setTargetName(this.getTargetName());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ReferenceTypeId.getSpecification());
        builder.addField(Fields.IsInverse.getSpecification());
        builder.addField(Fields.IncludeSubtypes.getSpecification());
        builder.addField(Fields.TargetName.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("RelativePathElement");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.RelativePathElementSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return RelativePathElement.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId referenceTypeId;
        private Boolean isInverse;
        private Boolean includeSubtypes;
        private QualifiedName targetName;

        protected Builder() {
        }

        public Builder setReferenceTypeId(NodeId nodeId) {
            this.referenceTypeId = nodeId;
            return this;
        }

        public Builder setIsInverse(Boolean bl) {
            this.isInverse = bl;
            return this;
        }

        public Builder setIncludeSubtypes(Boolean bl) {
            this.includeSubtypes = bl;
            return this;
        }

        public Builder setTargetName(QualifiedName qualifiedName) {
            this.targetName = qualifiedName;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ReferenceTypeId.getSpecification().equals(fieldSpecification)) {
                this.setReferenceTypeId((NodeId)object);
                return this;
            }
            if (Fields.IsInverse.getSpecification().equals(fieldSpecification)) {
                this.setIsInverse((Boolean)object);
                return this;
            }
            if (Fields.IncludeSubtypes.getSpecification().equals(fieldSpecification)) {
                this.setIncludeSubtypes((Boolean)object);
                return this;
            }
            if (Fields.TargetName.getSpecification().equals(fieldSpecification)) {
                this.setTargetName((QualifiedName)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public RelativePathElement build() {
            return new RelativePathElement(this.referenceTypeId, this.isInverse, this.includeSubtypes, this.targetName);
        }
    }

    public static enum Fields {
        ReferenceTypeId("ReferenceTypeId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        IsInverse("IsInverse", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1),
        IncludeSubtypes("IncludeSubtypes", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1),
        TargetName("TargetName", QualifiedName.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=20")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

