/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.RelativePathElement;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=540")
public class RelativePath
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.RelativePath_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.RelativePath_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.RelativePath_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.RelativePath;
    public static final StructureSpecification SPECIFICATION;
    private RelativePathElement[] elements;

    public RelativePath() {
    }

    public RelativePath(RelativePathElement[] relativePathElementArray) {
        this.elements = relativePathElementArray;
    }

    public RelativePathElement[] getElements() {
        return this.elements;
    }

    public void setElements(RelativePathElement[] relativePathElementArray) {
        this.elements = relativePathElementArray;
    }

    @Override
    public RelativePath clone() {
        RelativePath relativePath = (RelativePath)super.clone();
        relativePath.elements = StructureUtils.clone(this.elements);
        return relativePath;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelativePath relativePath = (RelativePath)object;
        return StructureUtils.scalarOrArrayEquals(this.getElements(), relativePath.getElements());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getElements());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Elements.getSpecification().equals(fieldSpecification)) {
            return this.getElements();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Elements.getSpecification().equals(fieldSpecification)) {
            this.setElements((RelativePathElement[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = RelativePath.builder();
        builder.setElements(this.getElements());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Elements.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("RelativePath");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.RelativePathSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return RelativePath.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RelativePathElement[] elements;

        protected Builder() {
        }

        public Builder setElements(RelativePathElement[] relativePathElementArray) {
            this.elements = relativePathElementArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Elements.getSpecification().equals(fieldSpecification)) {
                this.setElements((RelativePathElement[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public RelativePath build() {
            return new RelativePath(this.elements);
        }
    }

    public static enum Fields {
        Elements("Elements", RelativePathElement[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=537")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

