/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.RegisterServer2Response;
import com.prosysopc.ua.stack.core.RegisteredServer;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12193")
public class RegisterServer2Request
extends AbstractStructure
implements ServiceRequest<RegisterServer2Response> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.RegisterServer2Request_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.RegisterServer2Request_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.RegisterServer2Request_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.RegisterServer2Request;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private RegisteredServer server;
    private ExtensionObject[] discoveryConfiguration;

    public RegisterServer2Request() {
    }

    public RegisterServer2Request(RequestHeader requestHeader, RegisteredServer registeredServer, ExtensionObject[] extensionObjectArray) {
        this.requestHeader = requestHeader;
        this.server = registeredServer;
        this.discoveryConfiguration = extensionObjectArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public RegisteredServer getServer() {
        return this.server;
    }

    public void setServer(RegisteredServer registeredServer) {
        this.server = registeredServer;
    }

    public ExtensionObject[] getDiscoveryConfiguration() {
        return this.discoveryConfiguration;
    }

    public void setDiscoveryConfiguration(ExtensionObject[] extensionObjectArray) {
        this.discoveryConfiguration = extensionObjectArray;
    }

    @Override
    public RegisterServer2Request clone() {
        RegisterServer2Request registerServer2Request = (RegisterServer2Request)super.clone();
        registerServer2Request.requestHeader = StructureUtils.clone(this.requestHeader);
        registerServer2Request.server = StructureUtils.clone(this.server);
        registerServer2Request.discoveryConfiguration = StructureUtils.clone(this.discoveryConfiguration);
        return registerServer2Request;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RegisterServer2Request registerServer2Request = (RegisterServer2Request)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), registerServer2Request.getRequestHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getServer(), registerServer2Request.getServer())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDiscoveryConfiguration(), registerServer2Request.getDiscoveryConfiguration());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getServer(), this.getDiscoveryConfiguration());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.Server.getSpecification().equals(fieldSpecification)) {
            return this.getServer();
        }
        if (Fields.DiscoveryConfiguration.getSpecification().equals(fieldSpecification)) {
            return this.getDiscoveryConfiguration();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.Server.getSpecification().equals(fieldSpecification)) {
            this.setServer((RegisteredServer)object);
            return;
        }
        if (Fields.DiscoveryConfiguration.getSpecification().equals(fieldSpecification)) {
            this.setDiscoveryConfiguration((ExtensionObject[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = RegisterServer2Request.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setServer(this.getServer());
        builder.setDiscoveryConfiguration(this.getDiscoveryConfiguration());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.Server.getSpecification());
        builder.addField(Fields.DiscoveryConfiguration.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("RegisterServer2Request");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.RegisterServer2RequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return RegisterServer2Request.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private RegisteredServer server;
        private ExtensionObject[] discoveryConfiguration;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setServer(RegisteredServer registeredServer) {
            this.server = registeredServer;
            return this;
        }

        public Builder setDiscoveryConfiguration(ExtensionObject[] extensionObjectArray) {
            this.discoveryConfiguration = extensionObjectArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.Server.getSpecification().equals(fieldSpecification)) {
                this.setServer((RegisteredServer)object);
                return this;
            }
            if (Fields.DiscoveryConfiguration.getSpecification().equals(fieldSpecification)) {
                this.setDiscoveryConfiguration((ExtensionObject[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public RegisterServer2Request build() {
            return new RegisterServer2Request(this.requestHeader, this.server, this.discoveryConfiguration);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        Server("Server", RegisteredServer.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=432")), -1),
        DiscoveryConfiguration("DiscoveryConfiguration", Structure[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=22")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

