/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ReadResponse;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=629")
public class ReadRequest
extends AbstractStructure
implements ServiceRequest<ReadResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ReadRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ReadRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ReadRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ReadRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private Double maxAge;
    private TimestampsToReturn timestampsToReturn;
    private ReadValueId[] nodesToRead;

    public ReadRequest() {
    }

    public ReadRequest(RequestHeader requestHeader, Double d2, TimestampsToReturn timestampsToReturn, ReadValueId[] readValueIdArray) {
        this.requestHeader = requestHeader;
        this.maxAge = d2;
        this.timestampsToReturn = timestampsToReturn;
        this.nodesToRead = readValueIdArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public Double getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Double d2) {
        this.maxAge = d2;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public void setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
        this.timestampsToReturn = timestampsToReturn;
    }

    public ReadValueId[] getNodesToRead() {
        return this.nodesToRead;
    }

    public void setNodesToRead(ReadValueId[] readValueIdArray) {
        this.nodesToRead = readValueIdArray;
    }

    @Override
    public ReadRequest clone() {
        ReadRequest readRequest = (ReadRequest)super.clone();
        readRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        readRequest.maxAge = StructureUtils.clone(this.maxAge);
        readRequest.timestampsToReturn = StructureUtils.clone(this.timestampsToReturn);
        readRequest.nodesToRead = StructureUtils.clone(this.nodesToRead);
        return readRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReadRequest readRequest = (ReadRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), readRequest.getRequestHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getMaxAge(), readRequest.getMaxAge())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTimestampsToReturn(), readRequest.getTimestampsToReturn())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getNodesToRead(), readRequest.getNodesToRead());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getMaxAge(), this.getTimestampsToReturn(), this.getNodesToRead());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.MaxAge.getSpecification().equals(fieldSpecification)) {
            return this.getMaxAge();
        }
        if (Fields.TimestampsToReturn.getSpecification().equals(fieldSpecification)) {
            return this.getTimestampsToReturn();
        }
        if (Fields.NodesToRead.getSpecification().equals(fieldSpecification)) {
            return this.getNodesToRead();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.MaxAge.getSpecification().equals(fieldSpecification)) {
            this.setMaxAge((Double)object);
            return;
        }
        if (Fields.TimestampsToReturn.getSpecification().equals(fieldSpecification)) {
            this.setTimestampsToReturn((TimestampsToReturn)object);
            return;
        }
        if (Fields.NodesToRead.getSpecification().equals(fieldSpecification)) {
            this.setNodesToRead((ReadValueId[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ReadRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setMaxAge(this.getMaxAge());
        builder.setTimestampsToReturn(this.getTimestampsToReturn());
        builder.setNodesToRead(this.getNodesToRead());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.MaxAge.getSpecification());
        builder.addField(Fields.TimestampsToReturn.getSpecification());
        builder.addField(Fields.NodesToRead.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ReadRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ReadRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ReadRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private Double maxAge;
        private TimestampsToReturn timestampsToReturn;
        private ReadValueId[] nodesToRead;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setMaxAge(Double d2) {
            this.maxAge = d2;
            return this;
        }

        public Builder setTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
            this.timestampsToReturn = timestampsToReturn;
            return this;
        }

        public Builder setNodesToRead(ReadValueId[] readValueIdArray) {
            this.nodesToRead = readValueIdArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.MaxAge.getSpecification().equals(fieldSpecification)) {
                this.setMaxAge((Double)object);
                return this;
            }
            if (Fields.TimestampsToReturn.getSpecification().equals(fieldSpecification)) {
                this.setTimestampsToReturn((TimestampsToReturn)object);
                return this;
            }
            if (Fields.NodesToRead.getSpecification().equals(fieldSpecification)) {
                this.setNodesToRead((ReadValueId[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ReadRequest build() {
            return new ReadRequest(this.requestHeader, this.maxAge, this.timestampsToReturn, this.nodesToRead);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        MaxAge("MaxAge", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=290")), -1),
        TimestampsToReturn("TimestampsToReturn", TimestampsToReturn.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=625")), -1),
        NodesToRead("NodesToRead", ReadValueId[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=626")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

