/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=644")
public class ReadEventDetails
extends HistoryReadDetails {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ReadEventDetails_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ReadEventDetails_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ReadEventDetails_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ReadEventDetails;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger numValuesPerNode;
    private DateTime startTime;
    private DateTime endTime;
    private EventFilter filter;

    public ReadEventDetails() {
    }

    public ReadEventDetails(UnsignedInteger unsignedInteger, DateTime dateTime, DateTime dateTime2, EventFilter eventFilter) {
        this.numValuesPerNode = unsignedInteger;
        this.startTime = dateTime;
        this.endTime = dateTime2;
        this.filter = eventFilter;
    }

    public UnsignedInteger getNumValuesPerNode() {
        return this.numValuesPerNode;
    }

    public void setNumValuesPerNode(UnsignedInteger unsignedInteger) {
        this.numValuesPerNode = unsignedInteger;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.startTime = dateTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(DateTime dateTime) {
        this.endTime = dateTime;
    }

    public EventFilter getFilter() {
        return this.filter;
    }

    public void setFilter(EventFilter eventFilter) {
        this.filter = eventFilter;
    }

    @Override
    public ReadEventDetails clone() {
        ReadEventDetails readEventDetails = (ReadEventDetails)super.clone();
        readEventDetails.numValuesPerNode = StructureUtils.clone(this.numValuesPerNode);
        readEventDetails.startTime = StructureUtils.clone(this.startTime);
        readEventDetails.endTime = StructureUtils.clone(this.endTime);
        readEventDetails.filter = StructureUtils.clone(this.filter);
        return readEventDetails;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReadEventDetails readEventDetails = (ReadEventDetails)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNumValuesPerNode(), readEventDetails.getNumValuesPerNode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getStartTime(), readEventDetails.getStartTime())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getEndTime(), readEventDetails.getEndTime())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getFilter(), readEventDetails.getFilter());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getNumValuesPerNode(), this.getStartTime(), this.getEndTime(), this.getFilter());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.NumValuesPerNode.getSpecification().equals(fieldSpecification)) {
            return this.getNumValuesPerNode();
        }
        if (Fields.StartTime.getSpecification().equals(fieldSpecification)) {
            return this.getStartTime();
        }
        if (Fields.EndTime.getSpecification().equals(fieldSpecification)) {
            return this.getEndTime();
        }
        if (Fields.Filter.getSpecification().equals(fieldSpecification)) {
            return this.getFilter();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.NumValuesPerNode.getSpecification().equals(fieldSpecification)) {
            this.setNumValuesPerNode((UnsignedInteger)object);
            return;
        }
        if (Fields.StartTime.getSpecification().equals(fieldSpecification)) {
            this.setStartTime((DateTime)object);
            return;
        }
        if (Fields.EndTime.getSpecification().equals(fieldSpecification)) {
            this.setEndTime((DateTime)object);
            return;
        }
        if (Fields.Filter.getSpecification().equals(fieldSpecification)) {
            this.setFilter((EventFilter)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ReadEventDetails.builder();
        builder.setNumValuesPerNode(this.getNumValuesPerNode());
        builder.setStartTime(this.getStartTime());
        builder.setEndTime(this.getEndTime());
        builder.setFilter(this.getFilter());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.NumValuesPerNode.getSpecification());
        builder.addField(Fields.StartTime.getSpecification());
        builder.addField(Fields.EndTime.getSpecification());
        builder.addField(Fields.Filter.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ReadEventDetails");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ReadEventDetailsSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ReadEventDetails.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends HistoryReadDetails.Builder {
        private UnsignedInteger numValuesPerNode;
        private DateTime startTime;
        private DateTime endTime;
        private EventFilter filter;

        protected Builder() {
        }

        public Builder setNumValuesPerNode(UnsignedInteger unsignedInteger) {
            this.numValuesPerNode = unsignedInteger;
            return this;
        }

        public Builder setStartTime(DateTime dateTime) {
            this.startTime = dateTime;
            return this;
        }

        public Builder setEndTime(DateTime dateTime) {
            this.endTime = dateTime;
            return this;
        }

        public Builder setFilter(EventFilter eventFilter) {
            this.filter = eventFilter;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.NumValuesPerNode.getSpecification().equals(fieldSpecification)) {
                this.setNumValuesPerNode((UnsignedInteger)object);
                return this;
            }
            if (Fields.StartTime.getSpecification().equals(fieldSpecification)) {
                this.setStartTime((DateTime)object);
                return this;
            }
            if (Fields.EndTime.getSpecification().equals(fieldSpecification)) {
                this.setEndTime((DateTime)object);
                return this;
            }
            if (Fields.Filter.getSpecification().equals(fieldSpecification)) {
                this.setFilter((EventFilter)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ReadEventDetails build() {
            return new ReadEventDetails(this.numValuesPerNode, this.startTime, this.endTime, this.filter);
        }
    }

    public static enum Fields {
        NumValuesPerNode("NumValuesPerNode", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=289")), -1),
        StartTime("StartTime", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1),
        EndTime("EndTime", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1),
        Filter("Filter", EventFilter.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=725")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

