/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18806")
public class RationalNumber
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.RationalNumber_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.RationalNumber_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.RationalNumber_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.RationalNumber;
    public static final StructureSpecification SPECIFICATION;
    private Integer numerator;
    private UnsignedInteger denominator;

    public RationalNumber() {
    }

    public RationalNumber(Integer n2, UnsignedInteger unsignedInteger) {
        this.numerator = n2;
        this.denominator = unsignedInteger;
    }

    public Integer getNumerator() {
        return this.numerator;
    }

    public void setNumerator(Integer n2) {
        this.numerator = n2;
    }

    public UnsignedInteger getDenominator() {
        return this.denominator;
    }

    public void setDenominator(UnsignedInteger unsignedInteger) {
        this.denominator = unsignedInteger;
    }

    @Override
    public RationalNumber clone() {
        RationalNumber rationalNumber = (RationalNumber)super.clone();
        rationalNumber.numerator = StructureUtils.clone(this.numerator);
        rationalNumber.denominator = StructureUtils.clone(this.denominator);
        return rationalNumber;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RationalNumber rationalNumber = (RationalNumber)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNumerator(), rationalNumber.getNumerator())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDenominator(), rationalNumber.getDenominator());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getNumerator(), this.getDenominator());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Numerator.getSpecification().equals(fieldSpecification)) {
            return this.getNumerator();
        }
        if (Fields.Denominator.getSpecification().equals(fieldSpecification)) {
            return this.getDenominator();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Numerator.getSpecification().equals(fieldSpecification)) {
            this.setNumerator((Integer)object);
            return;
        }
        if (Fields.Denominator.getSpecification().equals(fieldSpecification)) {
            this.setDenominator((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = RationalNumber.builder();
        builder.setNumerator(this.getNumerator());
        builder.setDenominator(this.getDenominator());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Numerator.getSpecification());
        builder.addField(Fields.Denominator.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("RationalNumber");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.RationalNumberSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return RationalNumber.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Integer numerator;
        private UnsignedInteger denominator;

        protected Builder() {
        }

        public Builder setNumerator(Integer n2) {
            this.numerator = n2;
            return this;
        }

        public Builder setDenominator(UnsignedInteger unsignedInteger) {
            this.denominator = unsignedInteger;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Numerator.getSpecification().equals(fieldSpecification)) {
                this.setNumerator((Integer)object);
                return this;
            }
            if (Fields.Denominator.getSpecification().equals(fieldSpecification)) {
                this.setDenominator((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public RationalNumber build() {
            return new RationalNumber(this.numerator, this.denominator);
        }
    }

    public static enum Fields {
        Numerator("Numerator", Integer.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=6")), -1),
        Denominator("Denominator", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

