/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.QueryNextResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=619")
public class QueryNextRequest
extends AbstractStructure
implements ServiceRequest<QueryNextResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.QueryNextRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.QueryNextRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.QueryNextRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.QueryNextRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private Boolean releaseContinuationPoint;
    private ByteString continuationPoint;

    public QueryNextRequest() {
    }

    public QueryNextRequest(RequestHeader requestHeader, Boolean bl, ByteString byteString) {
        this.requestHeader = requestHeader;
        this.releaseContinuationPoint = bl;
        this.continuationPoint = byteString;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public Boolean getReleaseContinuationPoint() {
        return this.releaseContinuationPoint;
    }

    public void setReleaseContinuationPoint(Boolean bl) {
        this.releaseContinuationPoint = bl;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    public void setContinuationPoint(ByteString byteString) {
        this.continuationPoint = byteString;
    }

    @Override
    public QueryNextRequest clone() {
        QueryNextRequest queryNextRequest = (QueryNextRequest)super.clone();
        queryNextRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        queryNextRequest.releaseContinuationPoint = StructureUtils.clone(this.releaseContinuationPoint);
        queryNextRequest.continuationPoint = StructureUtils.clone(this.continuationPoint);
        return queryNextRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QueryNextRequest queryNextRequest = (QueryNextRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), queryNextRequest.getRequestHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getReleaseContinuationPoint(), queryNextRequest.getReleaseContinuationPoint())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getContinuationPoint(), queryNextRequest.getContinuationPoint());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getReleaseContinuationPoint(), this.getContinuationPoint());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.ReleaseContinuationPoint.getSpecification().equals(fieldSpecification)) {
            return this.getReleaseContinuationPoint();
        }
        if (Fields.ContinuationPoint.getSpecification().equals(fieldSpecification)) {
            return this.getContinuationPoint();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.ReleaseContinuationPoint.getSpecification().equals(fieldSpecification)) {
            this.setReleaseContinuationPoint((Boolean)object);
            return;
        }
        if (Fields.ContinuationPoint.getSpecification().equals(fieldSpecification)) {
            this.setContinuationPoint((ByteString)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = QueryNextRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setReleaseContinuationPoint(this.getReleaseContinuationPoint());
        builder.setContinuationPoint(this.getContinuationPoint());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.ReleaseContinuationPoint.getSpecification());
        builder.addField(Fields.ContinuationPoint.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("QueryNextRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.QueryNextRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return QueryNextRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private Boolean releaseContinuationPoint;
        private ByteString continuationPoint;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setReleaseContinuationPoint(Boolean bl) {
            this.releaseContinuationPoint = bl;
            return this;
        }

        public Builder setContinuationPoint(ByteString byteString) {
            this.continuationPoint = byteString;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.ReleaseContinuationPoint.getSpecification().equals(fieldSpecification)) {
                this.setReleaseContinuationPoint((Boolean)object);
                return this;
            }
            if (Fields.ContinuationPoint.getSpecification().equals(fieldSpecification)) {
                this.setContinuationPoint((ByteString)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public QueryNextRequest build() {
            return new QueryNextRequest(this.requestHeader, this.releaseContinuationPoint, this.continuationPoint);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        ReleaseContinuationPoint("ReleaseContinuationPoint", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1),
        ContinuationPoint("ContinuationPoint", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=521")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

