/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ContentFilterResult;
import com.prosysopc.ua.stack.core.ParsingResult;
import com.prosysopc.ua.stack.core.QueryDataSet;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=616")
public class QueryFirstResponse
extends AbstractStructure
implements ServiceResponse {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.QueryFirstResponse_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.QueryFirstResponse_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.QueryFirstResponse_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.QueryFirstResponse;
    public static final StructureSpecification SPECIFICATION;
    private ResponseHeader responseHeader;
    private QueryDataSet[] queryDataSets;
    private ByteString continuationPoint;
    private ParsingResult[] parsingResults;
    private DiagnosticInfo[] diagnosticInfos;
    private ContentFilterResult filterResult;

    public QueryFirstResponse() {
    }

    public QueryFirstResponse(ResponseHeader responseHeader, QueryDataSet[] queryDataSetArray, ByteString byteString, ParsingResult[] parsingResultArray, DiagnosticInfo[] diagnosticInfoArray, ContentFilterResult contentFilterResult) {
        this.responseHeader = responseHeader;
        this.queryDataSets = queryDataSetArray;
        this.continuationPoint = byteString;
        this.parsingResults = parsingResultArray;
        this.diagnosticInfos = diagnosticInfoArray;
        this.filterResult = contentFilterResult;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.responseHeader = responseHeader;
    }

    public QueryDataSet[] getQueryDataSets() {
        return this.queryDataSets;
    }

    public void setQueryDataSets(QueryDataSet[] queryDataSetArray) {
        this.queryDataSets = queryDataSetArray;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    public void setContinuationPoint(ByteString byteString) {
        this.continuationPoint = byteString;
    }

    public ParsingResult[] getParsingResults() {
        return this.parsingResults;
    }

    public void setParsingResults(ParsingResult[] parsingResultArray) {
        this.parsingResults = parsingResultArray;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.diagnosticInfos = diagnosticInfoArray;
    }

    public ContentFilterResult getFilterResult() {
        return this.filterResult;
    }

    public void setFilterResult(ContentFilterResult contentFilterResult) {
        this.filterResult = contentFilterResult;
    }

    @Override
    public QueryFirstResponse clone() {
        QueryFirstResponse queryFirstResponse = (QueryFirstResponse)super.clone();
        queryFirstResponse.responseHeader = StructureUtils.clone(this.responseHeader);
        queryFirstResponse.queryDataSets = StructureUtils.clone(this.queryDataSets);
        queryFirstResponse.continuationPoint = StructureUtils.clone(this.continuationPoint);
        queryFirstResponse.parsingResults = StructureUtils.clone(this.parsingResults);
        queryFirstResponse.diagnosticInfos = StructureUtils.clone(this.diagnosticInfos);
        queryFirstResponse.filterResult = StructureUtils.clone(this.filterResult);
        return queryFirstResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QueryFirstResponse queryFirstResponse = (QueryFirstResponse)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getResponseHeader(), queryFirstResponse.getResponseHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getQueryDataSets(), queryFirstResponse.getQueryDataSets())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getContinuationPoint(), queryFirstResponse.getContinuationPoint())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getParsingResults(), queryFirstResponse.getParsingResults())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDiagnosticInfos(), queryFirstResponse.getDiagnosticInfos())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getFilterResult(), queryFirstResponse.getFilterResult());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getResponseHeader(), this.getQueryDataSets(), this.getContinuationPoint(), this.getParsingResults(), this.getDiagnosticInfos(), this.getFilterResult());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            return this.getResponseHeader();
        }
        if (Fields.QueryDataSets.getSpecification().equals(fieldSpecification)) {
            return this.getQueryDataSets();
        }
        if (Fields.ContinuationPoint.getSpecification().equals(fieldSpecification)) {
            return this.getContinuationPoint();
        }
        if (Fields.ParsingResults.getSpecification().equals(fieldSpecification)) {
            return this.getParsingResults();
        }
        if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            return this.getDiagnosticInfos();
        }
        if (Fields.FilterResult.getSpecification().equals(fieldSpecification)) {
            return this.getFilterResult();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            this.setResponseHeader((ResponseHeader)object);
            return;
        }
        if (Fields.QueryDataSets.getSpecification().equals(fieldSpecification)) {
            this.setQueryDataSets((QueryDataSet[])object);
            return;
        }
        if (Fields.ContinuationPoint.getSpecification().equals(fieldSpecification)) {
            this.setContinuationPoint((ByteString)object);
            return;
        }
        if (Fields.ParsingResults.getSpecification().equals(fieldSpecification)) {
            this.setParsingResults((ParsingResult[])object);
            return;
        }
        if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            this.setDiagnosticInfos((DiagnosticInfo[])object);
            return;
        }
        if (Fields.FilterResult.getSpecification().equals(fieldSpecification)) {
            this.setFilterResult((ContentFilterResult)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = QueryFirstResponse.builder();
        builder.setResponseHeader(this.getResponseHeader());
        builder.setQueryDataSets(this.getQueryDataSets());
        builder.setContinuationPoint(this.getContinuationPoint());
        builder.setParsingResults(this.getParsingResults());
        builder.setDiagnosticInfos(this.getDiagnosticInfos());
        builder.setFilterResult(this.getFilterResult());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ResponseHeader.getSpecification());
        builder.addField(Fields.QueryDataSets.getSpecification());
        builder.addField(Fields.ContinuationPoint.getSpecification());
        builder.addField(Fields.ParsingResults.getSpecification());
        builder.addField(Fields.DiagnosticInfos.getSpecification());
        builder.addField(Fields.FilterResult.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("QueryFirstResponse");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.QueryFirstResponseSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return QueryFirstResponse.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ResponseHeader responseHeader;
        private QueryDataSet[] queryDataSets;
        private ByteString continuationPoint;
        private ParsingResult[] parsingResults;
        private DiagnosticInfo[] diagnosticInfos;
        private ContentFilterResult filterResult;

        protected Builder() {
        }

        public Builder setResponseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return this;
        }

        public Builder setQueryDataSets(QueryDataSet[] queryDataSetArray) {
            this.queryDataSets = queryDataSetArray;
            return this;
        }

        public Builder setContinuationPoint(ByteString byteString) {
            this.continuationPoint = byteString;
            return this;
        }

        public Builder setParsingResults(ParsingResult[] parsingResultArray) {
            this.parsingResults = parsingResultArray;
            return this;
        }

        public Builder setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
            this.diagnosticInfos = diagnosticInfoArray;
            return this;
        }

        public Builder setFilterResult(ContentFilterResult contentFilterResult) {
            this.filterResult = contentFilterResult;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
                this.setResponseHeader((ResponseHeader)object);
                return this;
            }
            if (Fields.QueryDataSets.getSpecification().equals(fieldSpecification)) {
                this.setQueryDataSets((QueryDataSet[])object);
                return this;
            }
            if (Fields.ContinuationPoint.getSpecification().equals(fieldSpecification)) {
                this.setContinuationPoint((ByteString)object);
                return this;
            }
            if (Fields.ParsingResults.getSpecification().equals(fieldSpecification)) {
                this.setParsingResults((ParsingResult[])object);
                return this;
            }
            if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
                this.setDiagnosticInfos((DiagnosticInfo[])object);
                return this;
            }
            if (Fields.FilterResult.getSpecification().equals(fieldSpecification)) {
                this.setFilterResult((ContentFilterResult)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public QueryFirstResponse build() {
            return new QueryFirstResponse(this.responseHeader, this.queryDataSets, this.continuationPoint, this.parsingResults, this.diagnosticInfos, this.filterResult);
        }
    }

    public static enum Fields {
        ResponseHeader("ResponseHeader", ResponseHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=392")), -1),
        QueryDataSets("QueryDataSets", QueryDataSet[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=577")), 1),
        ContinuationPoint("ContinuationPoint", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=521")), -1),
        ParsingResults("ParsingResults", ParsingResult[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=610")), 1),
        DiagnosticInfos("DiagnosticInfos", DiagnosticInfo[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=25")), 1),
        FilterResult("FilterResult", ContentFilterResult.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=607")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

