/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=577")
public class QueryDataSet
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.QueryDataSet_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.QueryDataSet_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.QueryDataSet_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.QueryDataSet;
    public static final StructureSpecification SPECIFICATION;
    private ExpandedNodeId nodeId;
    private ExpandedNodeId typeDefinitionNode;
    private Object[] values;

    public QueryDataSet() {
    }

    public QueryDataSet(ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2, Object[] objectArray) {
        this.nodeId = expandedNodeId;
        this.typeDefinitionNode = expandedNodeId2;
        this.values = objectArray;
    }

    public ExpandedNodeId getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(ExpandedNodeId expandedNodeId) {
        this.nodeId = expandedNodeId;
    }

    public ExpandedNodeId getTypeDefinitionNode() {
        return this.typeDefinitionNode;
    }

    public void setTypeDefinitionNode(ExpandedNodeId expandedNodeId) {
        this.typeDefinitionNode = expandedNodeId;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] objectArray) {
        this.values = objectArray;
    }

    @Override
    public QueryDataSet clone() {
        QueryDataSet queryDataSet = (QueryDataSet)super.clone();
        queryDataSet.nodeId = StructureUtils.clone(this.nodeId);
        queryDataSet.typeDefinitionNode = StructureUtils.clone(this.typeDefinitionNode);
        queryDataSet.values = StructureUtils.clone(this.values);
        return queryDataSet;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QueryDataSet queryDataSet = (QueryDataSet)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNodeId(), queryDataSet.getNodeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTypeDefinitionNode(), queryDataSet.getTypeDefinitionNode())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getValues(), queryDataSet.getValues());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getNodeId(), this.getTypeDefinitionNode(), this.getValues());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
            return this.getNodeId();
        }
        if (Fields.TypeDefinitionNode.getSpecification().equals(fieldSpecification)) {
            return this.getTypeDefinitionNode();
        }
        if (Fields.Values.getSpecification().equals(fieldSpecification)) {
            return this.getValues();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
            this.setNodeId((ExpandedNodeId)object);
            return;
        }
        if (Fields.TypeDefinitionNode.getSpecification().equals(fieldSpecification)) {
            this.setTypeDefinitionNode((ExpandedNodeId)object);
            return;
        }
        if (Fields.Values.getSpecification().equals(fieldSpecification)) {
            this.setValues((Object[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = QueryDataSet.builder();
        builder.setNodeId(this.getNodeId());
        builder.setTypeDefinitionNode(this.getTypeDefinitionNode());
        builder.setValues(this.getValues());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.NodeId.getSpecification());
        builder.addField(Fields.TypeDefinitionNode.getSpecification());
        builder.addField(Fields.Values.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("QueryDataSet");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.QueryDataSetSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return QueryDataSet.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ExpandedNodeId nodeId;
        private ExpandedNodeId typeDefinitionNode;
        private Object[] values;

        protected Builder() {
        }

        public Builder setNodeId(ExpandedNodeId expandedNodeId) {
            this.nodeId = expandedNodeId;
            return this;
        }

        public Builder setTypeDefinitionNode(ExpandedNodeId expandedNodeId) {
            this.typeDefinitionNode = expandedNodeId;
            return this;
        }

        public Builder setValues(Object[] objectArray) {
            this.values = objectArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
                this.setNodeId((ExpandedNodeId)object);
                return this;
            }
            if (Fields.TypeDefinitionNode.getSpecification().equals(fieldSpecification)) {
                this.setTypeDefinitionNode((ExpandedNodeId)object);
                return this;
            }
            if (Fields.Values.getSpecification().equals(fieldSpecification)) {
                this.setValues((Object[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public QueryDataSet build() {
            return new QueryDataSet(this.nodeId, this.typeDefinitionNode, this.values);
        }
    }

    public static enum Fields {
        NodeId("NodeId", ExpandedNodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=18")), -1),
        TypeDefinitionNode("TypeDefinitionNode", ExpandedNodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=18")), -1),
        Values("Values", Object[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=24")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

