/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ContentFilter;
import com.prosysopc.ua.stack.core.PublishedDataSetSourceDataType;
import com.prosysopc.ua.stack.core.SimpleAttributeOperand;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15582")
public class PublishedEventsDataType
extends PublishedDataSetSourceDataType {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.PublishedEventsDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.PublishedEventsDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.PublishedEventsDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.PublishedEventsDataType;
    public static final StructureSpecification SPECIFICATION;
    private NodeId eventNotifier;
    private SimpleAttributeOperand[] selectedFields;
    private ContentFilter filter;

    public PublishedEventsDataType() {
    }

    public PublishedEventsDataType(NodeId nodeId, SimpleAttributeOperand[] simpleAttributeOperandArray, ContentFilter contentFilter) {
        this.eventNotifier = nodeId;
        this.selectedFields = simpleAttributeOperandArray;
        this.filter = contentFilter;
    }

    public NodeId getEventNotifier() {
        return this.eventNotifier;
    }

    public void setEventNotifier(NodeId nodeId) {
        this.eventNotifier = nodeId;
    }

    public SimpleAttributeOperand[] getSelectedFields() {
        return this.selectedFields;
    }

    public void setSelectedFields(SimpleAttributeOperand[] simpleAttributeOperandArray) {
        this.selectedFields = simpleAttributeOperandArray;
    }

    public ContentFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ContentFilter contentFilter) {
        this.filter = contentFilter;
    }

    @Override
    public PublishedEventsDataType clone() {
        PublishedEventsDataType publishedEventsDataType = (PublishedEventsDataType)super.clone();
        publishedEventsDataType.eventNotifier = StructureUtils.clone(this.eventNotifier);
        publishedEventsDataType.selectedFields = StructureUtils.clone(this.selectedFields);
        publishedEventsDataType.filter = StructureUtils.clone(this.filter);
        return publishedEventsDataType;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PublishedEventsDataType publishedEventsDataType = (PublishedEventsDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getEventNotifier(), publishedEventsDataType.getEventNotifier())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSelectedFields(), publishedEventsDataType.getSelectedFields())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getFilter(), publishedEventsDataType.getFilter());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getEventNotifier(), this.getSelectedFields(), this.getFilter());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.EventNotifier.getSpecification().equals(fieldSpecification)) {
            return this.getEventNotifier();
        }
        if (Fields.SelectedFields.getSpecification().equals(fieldSpecification)) {
            return this.getSelectedFields();
        }
        if (Fields.Filter.getSpecification().equals(fieldSpecification)) {
            return this.getFilter();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.EventNotifier.getSpecification().equals(fieldSpecification)) {
            this.setEventNotifier((NodeId)object);
            return;
        }
        if (Fields.SelectedFields.getSpecification().equals(fieldSpecification)) {
            this.setSelectedFields((SimpleAttributeOperand[])object);
            return;
        }
        if (Fields.Filter.getSpecification().equals(fieldSpecification)) {
            this.setFilter((ContentFilter)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = PublishedEventsDataType.builder();
        builder.setEventNotifier(this.getEventNotifier());
        builder.setSelectedFields(this.getSelectedFields());
        builder.setFilter(this.getFilter());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.EventNotifier.getSpecification());
        builder.addField(Fields.SelectedFields.getSpecification());
        builder.addField(Fields.Filter.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("PublishedEventsDataType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.PublishedEventsDataTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return PublishedEventsDataType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends PublishedDataSetSourceDataType.Builder {
        private NodeId eventNotifier;
        private SimpleAttributeOperand[] selectedFields;
        private ContentFilter filter;

        protected Builder() {
        }

        public Builder setEventNotifier(NodeId nodeId) {
            this.eventNotifier = nodeId;
            return this;
        }

        public Builder setSelectedFields(SimpleAttributeOperand[] simpleAttributeOperandArray) {
            this.selectedFields = simpleAttributeOperandArray;
            return this;
        }

        public Builder setFilter(ContentFilter contentFilter) {
            this.filter = contentFilter;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.EventNotifier.getSpecification().equals(fieldSpecification)) {
                this.setEventNotifier((NodeId)object);
                return this;
            }
            if (Fields.SelectedFields.getSpecification().equals(fieldSpecification)) {
                this.setSelectedFields((SimpleAttributeOperand[])object);
                return this;
            }
            if (Fields.Filter.getSpecification().equals(fieldSpecification)) {
                this.setFilter((ContentFilter)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public PublishedEventsDataType build() {
            return new PublishedEventsDataType(this.eventNotifier, this.selectedFields, this.filter);
        }
    }

    public static enum Fields {
        EventNotifier("EventNotifier", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        SelectedFields("SelectedFields", SimpleAttributeOperand[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=601")), 1),
        Filter("Filter", ContentFilter.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=586")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

