/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.PublishResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.SubscriptionAcknowledgement;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=824")
public class PublishRequest
extends AbstractStructure
implements ServiceRequest<PublishResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.PublishRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.PublishRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.PublishRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.PublishRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private SubscriptionAcknowledgement[] subscriptionAcknowledgements;

    public PublishRequest() {
    }

    public PublishRequest(RequestHeader requestHeader, SubscriptionAcknowledgement[] subscriptionAcknowledgementArray) {
        this.requestHeader = requestHeader;
        this.subscriptionAcknowledgements = subscriptionAcknowledgementArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public SubscriptionAcknowledgement[] getSubscriptionAcknowledgements() {
        return this.subscriptionAcknowledgements;
    }

    public void setSubscriptionAcknowledgements(SubscriptionAcknowledgement[] subscriptionAcknowledgementArray) {
        this.subscriptionAcknowledgements = subscriptionAcknowledgementArray;
    }

    @Override
    public PublishRequest clone() {
        PublishRequest publishRequest = (PublishRequest)super.clone();
        publishRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        publishRequest.subscriptionAcknowledgements = StructureUtils.clone(this.subscriptionAcknowledgements);
        return publishRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PublishRequest publishRequest = (PublishRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), publishRequest.getRequestHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getSubscriptionAcknowledgements(), publishRequest.getSubscriptionAcknowledgements());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getSubscriptionAcknowledgements());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.SubscriptionAcknowledgements.getSpecification().equals(fieldSpecification)) {
            return this.getSubscriptionAcknowledgements();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.SubscriptionAcknowledgements.getSpecification().equals(fieldSpecification)) {
            this.setSubscriptionAcknowledgements((SubscriptionAcknowledgement[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = PublishRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setSubscriptionAcknowledgements(this.getSubscriptionAcknowledgements());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.SubscriptionAcknowledgements.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("PublishRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.PublishRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return PublishRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private SubscriptionAcknowledgement[] subscriptionAcknowledgements;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setSubscriptionAcknowledgements(SubscriptionAcknowledgement[] subscriptionAcknowledgementArray) {
            this.subscriptionAcknowledgements = subscriptionAcknowledgementArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.SubscriptionAcknowledgements.getSpecification().equals(fieldSpecification)) {
                this.setSubscriptionAcknowledgements((SubscriptionAcknowledgement[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public PublishRequest build() {
            return new PublishRequest(this.requestHeader, this.subscriptionAcknowledgements);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        SubscriptionAcknowledgements("SubscriptionAcknowledgements", SubscriptionAcknowledgement[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=821")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

