/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12755")
public class OptionSet
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.OptionSet_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.OptionSet_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.OptionSet_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.OptionSet;
    public static final StructureSpecification SPECIFICATION;
    private ByteString value;
    private ByteString validBits;

    public OptionSet() {
    }

    public OptionSet(ByteString byteString, ByteString byteString2) {
        this.value = byteString;
        this.validBits = byteString2;
    }

    public ByteString getValue() {
        return this.value;
    }

    public void setValue(ByteString byteString) {
        this.value = byteString;
    }

    public ByteString getValidBits() {
        return this.validBits;
    }

    public void setValidBits(ByteString byteString) {
        this.validBits = byteString;
    }

    @Override
    public OptionSet clone() {
        OptionSet optionSet = (OptionSet)super.clone();
        optionSet.value = StructureUtils.clone(this.value);
        optionSet.validBits = StructureUtils.clone(this.validBits);
        return optionSet;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OptionSet optionSet = (OptionSet)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getValue(), optionSet.getValue())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getValidBits(), optionSet.getValidBits());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getValue(), this.getValidBits());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            return this.getValue();
        }
        if (Fields.ValidBits.getSpecification().equals(fieldSpecification)) {
            return this.getValidBits();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            this.setValue((ByteString)object);
            return;
        }
        if (Fields.ValidBits.getSpecification().equals(fieldSpecification)) {
            this.setValidBits((ByteString)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = OptionSet.builder();
        builder.setValue(this.getValue());
        builder.setValidBits(this.getValidBits());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Value.getSpecification());
        builder.addField(Fields.ValidBits.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("OptionSet");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.OptionSetSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return OptionSet.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ByteString value;
        private ByteString validBits;

        protected Builder() {
        }

        public Builder setValue(ByteString byteString) {
            this.value = byteString;
            return this;
        }

        public Builder setValidBits(ByteString byteString) {
            this.validBits = byteString;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Value.getSpecification().equals(fieldSpecification)) {
                this.setValue((ByteString)object);
                return this;
            }
            if (Fields.ValidBits.getSpecification().equals(fieldSpecification)) {
                this.setValidBits((ByteString)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public OptionSet build() {
            return new OptionSet(this.value, this.validBits);
        }
    }

    public static enum Fields {
        Value("Value", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), -1),
        ValidBits("ValidBits", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

