/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=803")
public class NotificationMessage
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.NotificationMessage_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.NotificationMessage_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.NotificationMessage_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.NotificationMessage;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger sequenceNumber;
    private DateTime publishTime;
    private ExtensionObject[] notificationData;

    public NotificationMessage() {
    }

    public NotificationMessage(UnsignedInteger unsignedInteger, DateTime dateTime, ExtensionObject[] extensionObjectArray) {
        this.sequenceNumber = unsignedInteger;
        this.publishTime = dateTime;
        this.notificationData = extensionObjectArray;
    }

    public UnsignedInteger getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(UnsignedInteger unsignedInteger) {
        this.sequenceNumber = unsignedInteger;
    }

    public DateTime getPublishTime() {
        return this.publishTime;
    }

    public void setPublishTime(DateTime dateTime) {
        this.publishTime = dateTime;
    }

    public ExtensionObject[] getNotificationData() {
        return this.notificationData;
    }

    public void setNotificationData(ExtensionObject[] extensionObjectArray) {
        this.notificationData = extensionObjectArray;
    }

    @Override
    public NotificationMessage clone() {
        NotificationMessage notificationMessage = (NotificationMessage)super.clone();
        notificationMessage.sequenceNumber = StructureUtils.clone(this.sequenceNumber);
        notificationMessage.publishTime = StructureUtils.clone(this.publishTime);
        notificationMessage.notificationData = StructureUtils.clone(this.notificationData);
        return notificationMessage;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NotificationMessage notificationMessage = (NotificationMessage)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getSequenceNumber(), notificationMessage.getSequenceNumber())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getPublishTime(), notificationMessage.getPublishTime())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getNotificationData(), notificationMessage.getNotificationData());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getSequenceNumber(), this.getPublishTime(), this.getNotificationData());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.SequenceNumber.getSpecification().equals(fieldSpecification)) {
            return this.getSequenceNumber();
        }
        if (Fields.PublishTime.getSpecification().equals(fieldSpecification)) {
            return this.getPublishTime();
        }
        if (Fields.NotificationData.getSpecification().equals(fieldSpecification)) {
            return this.getNotificationData();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.SequenceNumber.getSpecification().equals(fieldSpecification)) {
            this.setSequenceNumber((UnsignedInteger)object);
            return;
        }
        if (Fields.PublishTime.getSpecification().equals(fieldSpecification)) {
            this.setPublishTime((DateTime)object);
            return;
        }
        if (Fields.NotificationData.getSpecification().equals(fieldSpecification)) {
            this.setNotificationData((ExtensionObject[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = NotificationMessage.builder();
        builder.setSequenceNumber(this.getSequenceNumber());
        builder.setPublishTime(this.getPublishTime());
        builder.setNotificationData(this.getNotificationData());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.SequenceNumber.getSpecification());
        builder.addField(Fields.PublishTime.getSpecification());
        builder.addField(Fields.NotificationData.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("NotificationMessage");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.NotificationMessageSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return NotificationMessage.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private UnsignedInteger sequenceNumber;
        private DateTime publishTime;
        private ExtensionObject[] notificationData;

        protected Builder() {
        }

        public Builder setSequenceNumber(UnsignedInteger unsignedInteger) {
            this.sequenceNumber = unsignedInteger;
            return this;
        }

        public Builder setPublishTime(DateTime dateTime) {
            this.publishTime = dateTime;
            return this;
        }

        public Builder setNotificationData(ExtensionObject[] extensionObjectArray) {
            this.notificationData = extensionObjectArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.SequenceNumber.getSpecification().equals(fieldSpecification)) {
                this.setSequenceNumber((UnsignedInteger)object);
                return this;
            }
            if (Fields.PublishTime.getSpecification().equals(fieldSpecification)) {
                this.setPublishTime((DateTime)object);
                return this;
            }
            if (Fields.NotificationData.getSpecification().equals(fieldSpecification)) {
                this.setNotificationData((ExtensionObject[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public NotificationMessage build() {
            return new NotificationMessage(this.sequenceNumber, this.publishTime, this.notificationData);
        }
    }

    public static enum Fields {
        SequenceNumber("SequenceNumber", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=289")), -1),
        PublishTime("PublishTime", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1),
        NotificationData("NotificationData", Structure[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=22")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

