/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=580")
public class NodeReference
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.NodeReference_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.NodeReference_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.NodeReference_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.NodeReference;
    public static final StructureSpecification SPECIFICATION;
    private NodeId nodeId;
    private NodeId referenceTypeId;
    private Boolean isForward;
    private NodeId[] referencedNodeIds;

    public NodeReference() {
    }

    public NodeReference(NodeId nodeId, NodeId nodeId2, Boolean bl, NodeId[] nodeIdArray) {
        this.nodeId = nodeId;
        this.referenceTypeId = nodeId2;
        this.isForward = bl;
        this.referencedNodeIds = nodeIdArray;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(NodeId nodeId) {
        this.nodeId = nodeId;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public void setReferenceTypeId(NodeId nodeId) {
        this.referenceTypeId = nodeId;
    }

    public Boolean getIsForward() {
        return this.isForward;
    }

    public void setIsForward(Boolean bl) {
        this.isForward = bl;
    }

    public NodeId[] getReferencedNodeIds() {
        return this.referencedNodeIds;
    }

    public void setReferencedNodeIds(NodeId[] nodeIdArray) {
        this.referencedNodeIds = nodeIdArray;
    }

    @Override
    public NodeReference clone() {
        NodeReference nodeReference = (NodeReference)super.clone();
        nodeReference.nodeId = StructureUtils.clone(this.nodeId);
        nodeReference.referenceTypeId = StructureUtils.clone(this.referenceTypeId);
        nodeReference.isForward = StructureUtils.clone(this.isForward);
        nodeReference.referencedNodeIds = StructureUtils.clone(this.referencedNodeIds);
        return nodeReference;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NodeReference nodeReference = (NodeReference)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNodeId(), nodeReference.getNodeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getReferenceTypeId(), nodeReference.getReferenceTypeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIsForward(), nodeReference.getIsForward())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getReferencedNodeIds(), nodeReference.getReferencedNodeIds());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getNodeId(), this.getReferenceTypeId(), this.getIsForward(), this.getReferencedNodeIds());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
            return this.getNodeId();
        }
        if (Fields.ReferenceTypeId.getSpecification().equals(fieldSpecification)) {
            return this.getReferenceTypeId();
        }
        if (Fields.IsForward.getSpecification().equals(fieldSpecification)) {
            return this.getIsForward();
        }
        if (Fields.ReferencedNodeIds.getSpecification().equals(fieldSpecification)) {
            return this.getReferencedNodeIds();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
            this.setNodeId((NodeId)object);
            return;
        }
        if (Fields.ReferenceTypeId.getSpecification().equals(fieldSpecification)) {
            this.setReferenceTypeId((NodeId)object);
            return;
        }
        if (Fields.IsForward.getSpecification().equals(fieldSpecification)) {
            this.setIsForward((Boolean)object);
            return;
        }
        if (Fields.ReferencedNodeIds.getSpecification().equals(fieldSpecification)) {
            this.setReferencedNodeIds((NodeId[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = NodeReference.builder();
        builder.setNodeId(this.getNodeId());
        builder.setReferenceTypeId(this.getReferenceTypeId());
        builder.setIsForward(this.getIsForward());
        builder.setReferencedNodeIds(this.getReferencedNodeIds());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.NodeId.getSpecification());
        builder.addField(Fields.ReferenceTypeId.getSpecification());
        builder.addField(Fields.IsForward.getSpecification());
        builder.addField(Fields.ReferencedNodeIds.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("NodeReference");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.NodeReferenceSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return NodeReference.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId nodeId;
        private NodeId referenceTypeId;
        private Boolean isForward;
        private NodeId[] referencedNodeIds;

        protected Builder() {
        }

        public Builder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setReferenceTypeId(NodeId nodeId) {
            this.referenceTypeId = nodeId;
            return this;
        }

        public Builder setIsForward(Boolean bl) {
            this.isForward = bl;
            return this;
        }

        public Builder setReferencedNodeIds(NodeId[] nodeIdArray) {
            this.referencedNodeIds = nodeIdArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
                this.setNodeId((NodeId)object);
                return this;
            }
            if (Fields.ReferenceTypeId.getSpecification().equals(fieldSpecification)) {
                this.setReferenceTypeId((NodeId)object);
                return this;
            }
            if (Fields.IsForward.getSpecification().equals(fieldSpecification)) {
                this.setIsForward((Boolean)object);
                return this;
            }
            if (Fields.ReferencedNodeIds.getSpecification().equals(fieldSpecification)) {
                this.setReferencedNodeIds((NodeId[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public NodeReference build() {
            return new NodeReference(this.nodeId, this.referenceTypeId, this.isForward, this.referencedNodeIds);
        }
    }

    public static enum Fields {
        NodeId("NodeId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        ReferenceTypeId("ReferenceTypeId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        IsForward("IsForward", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1),
        ReferencedNodeIds("ReferencedNodeIds", NodeId[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

