/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.EndpointUrlListDataType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11944")
public class NetworkGroupDataType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.NetworkGroupDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.NetworkGroupDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.NetworkGroupDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.NetworkGroupDataType;
    public static final StructureSpecification SPECIFICATION;
    private String serverUri;
    private EndpointUrlListDataType[] networkPaths;

    public NetworkGroupDataType() {
    }

    public NetworkGroupDataType(String string, EndpointUrlListDataType[] endpointUrlListDataTypeArray) {
        this.serverUri = string;
        this.networkPaths = endpointUrlListDataTypeArray;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public void setServerUri(String string) {
        this.serverUri = string;
    }

    public EndpointUrlListDataType[] getNetworkPaths() {
        return this.networkPaths;
    }

    public void setNetworkPaths(EndpointUrlListDataType[] endpointUrlListDataTypeArray) {
        this.networkPaths = endpointUrlListDataTypeArray;
    }

    @Override
    public NetworkGroupDataType clone() {
        NetworkGroupDataType networkGroupDataType = (NetworkGroupDataType)super.clone();
        networkGroupDataType.serverUri = StructureUtils.clone(this.serverUri);
        networkGroupDataType.networkPaths = StructureUtils.clone(this.networkPaths);
        return networkGroupDataType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NetworkGroupDataType networkGroupDataType = (NetworkGroupDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getServerUri(), networkGroupDataType.getServerUri())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getNetworkPaths(), networkGroupDataType.getNetworkPaths());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getServerUri(), this.getNetworkPaths());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ServerUri.getSpecification().equals(fieldSpecification)) {
            return this.getServerUri();
        }
        if (Fields.NetworkPaths.getSpecification().equals(fieldSpecification)) {
            return this.getNetworkPaths();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ServerUri.getSpecification().equals(fieldSpecification)) {
            this.setServerUri((String)object);
            return;
        }
        if (Fields.NetworkPaths.getSpecification().equals(fieldSpecification)) {
            this.setNetworkPaths((EndpointUrlListDataType[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = NetworkGroupDataType.builder();
        builder.setServerUri(this.getServerUri());
        builder.setNetworkPaths(this.getNetworkPaths());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ServerUri.getSpecification());
        builder.addField(Fields.NetworkPaths.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("NetworkGroupDataType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.NetworkGroupDataTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return NetworkGroupDataType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String serverUri;
        private EndpointUrlListDataType[] networkPaths;

        protected Builder() {
        }

        public Builder setServerUri(String string) {
            this.serverUri = string;
            return this;
        }

        public Builder setNetworkPaths(EndpointUrlListDataType[] endpointUrlListDataTypeArray) {
            this.networkPaths = endpointUrlListDataTypeArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ServerUri.getSpecification().equals(fieldSpecification)) {
                this.setServerUri((String)object);
                return this;
            }
            if (Fields.NetworkPaths.getSpecification().equals(fieldSpecification)) {
                this.setNetworkPaths((EndpointUrlListDataType[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public NetworkGroupDataType build() {
            return new NetworkGroupDataType(this.serverUri, this.networkPaths);
        }
    }

    public static enum Fields {
        ServerUri("ServerUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        NetworkPaths("NetworkPaths", EndpointUrlListDataType[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11943")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

