/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.MonitoringParameters;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=755")
public class MonitoredItemModifyRequest
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.MonitoredItemModifyRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.MonitoredItemModifyRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.MonitoredItemModifyRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.MonitoredItemModifyRequest;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger monitoredItemId;
    private MonitoringParameters requestedParameters;

    public MonitoredItemModifyRequest() {
    }

    public MonitoredItemModifyRequest(UnsignedInteger unsignedInteger, MonitoringParameters monitoringParameters) {
        this.monitoredItemId = unsignedInteger;
        this.requestedParameters = monitoringParameters;
    }

    public UnsignedInteger getMonitoredItemId() {
        return this.monitoredItemId;
    }

    public void setMonitoredItemId(UnsignedInteger unsignedInteger) {
        this.monitoredItemId = unsignedInteger;
    }

    public MonitoringParameters getRequestedParameters() {
        return this.requestedParameters;
    }

    public void setRequestedParameters(MonitoringParameters monitoringParameters) {
        this.requestedParameters = monitoringParameters;
    }

    @Override
    public MonitoredItemModifyRequest clone() {
        MonitoredItemModifyRequest monitoredItemModifyRequest = (MonitoredItemModifyRequest)super.clone();
        monitoredItemModifyRequest.monitoredItemId = StructureUtils.clone(this.monitoredItemId);
        monitoredItemModifyRequest.requestedParameters = StructureUtils.clone(this.requestedParameters);
        return monitoredItemModifyRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MonitoredItemModifyRequest monitoredItemModifyRequest = (MonitoredItemModifyRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getMonitoredItemId(), monitoredItemModifyRequest.getMonitoredItemId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getRequestedParameters(), monitoredItemModifyRequest.getRequestedParameters());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getMonitoredItemId(), this.getRequestedParameters());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.MonitoredItemId.getSpecification().equals(fieldSpecification)) {
            return this.getMonitoredItemId();
        }
        if (Fields.RequestedParameters.getSpecification().equals(fieldSpecification)) {
            return this.getRequestedParameters();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.MonitoredItemId.getSpecification().equals(fieldSpecification)) {
            this.setMonitoredItemId((UnsignedInteger)object);
            return;
        }
        if (Fields.RequestedParameters.getSpecification().equals(fieldSpecification)) {
            this.setRequestedParameters((MonitoringParameters)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = MonitoredItemModifyRequest.builder();
        builder.setMonitoredItemId(this.getMonitoredItemId());
        builder.setRequestedParameters(this.getRequestedParameters());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.MonitoredItemId.getSpecification());
        builder.addField(Fields.RequestedParameters.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("MonitoredItemModifyRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.MonitoredItemModifyRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return MonitoredItemModifyRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private UnsignedInteger monitoredItemId;
        private MonitoringParameters requestedParameters;

        protected Builder() {
        }

        public Builder setMonitoredItemId(UnsignedInteger unsignedInteger) {
            this.monitoredItemId = unsignedInteger;
            return this;
        }

        public Builder setRequestedParameters(MonitoringParameters monitoringParameters) {
            this.requestedParameters = monitoringParameters;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.MonitoredItemId.getSpecification().equals(fieldSpecification)) {
                this.setMonitoredItemId((UnsignedInteger)object);
                return this;
            }
            if (Fields.RequestedParameters.getSpecification().equals(fieldSpecification)) {
                this.setRequestedParameters((MonitoringParameters)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public MonitoredItemModifyRequest build() {
            return new MonitoredItemModifyRequest(this.monitoredItemId, this.requestedParameters);
        }
    }

    public static enum Fields {
        MonitoredItemId("MonitoredItemId", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=288")), -1),
        RequestedParameters("RequestedParameters", MonitoringParameters.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=740")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

