/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.DiscoveryConfiguration;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12891")
public class MdnsDiscoveryConfiguration
extends DiscoveryConfiguration {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.MdnsDiscoveryConfiguration_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.MdnsDiscoveryConfiguration_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.MdnsDiscoveryConfiguration_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.MdnsDiscoveryConfiguration;
    public static final StructureSpecification SPECIFICATION;
    private String mdnsServerName;
    private String[] serverCapabilities;

    public MdnsDiscoveryConfiguration() {
    }

    public MdnsDiscoveryConfiguration(String string, String[] stringArray) {
        this.mdnsServerName = string;
        this.serverCapabilities = stringArray;
    }

    public String getMdnsServerName() {
        return this.mdnsServerName;
    }

    public void setMdnsServerName(String string) {
        this.mdnsServerName = string;
    }

    public String[] getServerCapabilities() {
        return this.serverCapabilities;
    }

    public void setServerCapabilities(String[] stringArray) {
        this.serverCapabilities = stringArray;
    }

    @Override
    public MdnsDiscoveryConfiguration clone() {
        MdnsDiscoveryConfiguration mdnsDiscoveryConfiguration = (MdnsDiscoveryConfiguration)super.clone();
        mdnsDiscoveryConfiguration.mdnsServerName = StructureUtils.clone(this.mdnsServerName);
        mdnsDiscoveryConfiguration.serverCapabilities = StructureUtils.clone(this.serverCapabilities);
        return mdnsDiscoveryConfiguration;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MdnsDiscoveryConfiguration mdnsDiscoveryConfiguration = (MdnsDiscoveryConfiguration)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getMdnsServerName(), mdnsDiscoveryConfiguration.getMdnsServerName())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getServerCapabilities(), mdnsDiscoveryConfiguration.getServerCapabilities());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getMdnsServerName(), this.getServerCapabilities());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.MdnsServerName.getSpecification().equals(fieldSpecification)) {
            return this.getMdnsServerName();
        }
        if (Fields.ServerCapabilities.getSpecification().equals(fieldSpecification)) {
            return this.getServerCapabilities();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.MdnsServerName.getSpecification().equals(fieldSpecification)) {
            this.setMdnsServerName((String)object);
            return;
        }
        if (Fields.ServerCapabilities.getSpecification().equals(fieldSpecification)) {
            this.setServerCapabilities((String[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = MdnsDiscoveryConfiguration.builder();
        builder.setMdnsServerName(this.getMdnsServerName());
        builder.setServerCapabilities(this.getServerCapabilities());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.MdnsServerName.getSpecification());
        builder.addField(Fields.ServerCapabilities.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("MdnsDiscoveryConfiguration");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.MdnsDiscoveryConfigurationSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return MdnsDiscoveryConfiguration.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends DiscoveryConfiguration.Builder {
        private String mdnsServerName;
        private String[] serverCapabilities;

        protected Builder() {
        }

        public Builder setMdnsServerName(String string) {
            this.mdnsServerName = string;
            return this;
        }

        public Builder setServerCapabilities(String[] stringArray) {
            this.serverCapabilities = stringArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.MdnsServerName.getSpecification().equals(fieldSpecification)) {
                this.setMdnsServerName((String)object);
                return this;
            }
            if (Fields.ServerCapabilities.getSpecification().equals(fieldSpecification)) {
                this.setServerCapabilities((String[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public MdnsDiscoveryConfiguration build() {
            return new MdnsDiscoveryConfiguration(this.mdnsServerName, this.serverCapabilities);
        }
    }

    public static enum Fields {
        MdnsServerName("MdnsServerName", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        ServerCapabilities("ServerCapabilities", String[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

