/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=938")
public class IssuedIdentityToken
extends UserIdentityToken {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.IssuedIdentityToken_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.IssuedIdentityToken_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.IssuedIdentityToken_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.IssuedIdentityToken;
    public static final StructureSpecification SPECIFICATION;
    private ByteString tokenData;
    private String encryptionAlgorithm;

    public IssuedIdentityToken() {
    }

    public IssuedIdentityToken(ByteString byteString, String string) {
        this.tokenData = byteString;
        this.encryptionAlgorithm = string;
    }

    public IssuedIdentityToken(String string, ByteString byteString, String string2) {
        super(string);
        this.tokenData = byteString;
        this.encryptionAlgorithm = string2;
    }

    public ByteString getTokenData() {
        return this.tokenData;
    }

    public void setTokenData(ByteString byteString) {
        this.tokenData = byteString;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String string) {
        this.encryptionAlgorithm = string;
    }

    @Override
    public IssuedIdentityToken clone() {
        IssuedIdentityToken issuedIdentityToken = (IssuedIdentityToken)super.clone();
        issuedIdentityToken.tokenData = StructureUtils.clone(this.tokenData);
        issuedIdentityToken.encryptionAlgorithm = StructureUtils.clone(this.encryptionAlgorithm);
        return issuedIdentityToken;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IssuedIdentityToken issuedIdentityToken = (IssuedIdentityToken)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getPolicyId(), issuedIdentityToken.getPolicyId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTokenData(), issuedIdentityToken.getTokenData())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getEncryptionAlgorithm(), issuedIdentityToken.getEncryptionAlgorithm());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getPolicyId(), this.getTokenData(), this.getEncryptionAlgorithm());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
            return this.getPolicyId();
        }
        if (Fields.TokenData.getSpecification().equals(fieldSpecification)) {
            return this.getTokenData();
        }
        if (Fields.EncryptionAlgorithm.getSpecification().equals(fieldSpecification)) {
            return this.getEncryptionAlgorithm();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
            this.setPolicyId((String)object);
            return;
        }
        if (Fields.TokenData.getSpecification().equals(fieldSpecification)) {
            this.setTokenData((ByteString)object);
            return;
        }
        if (Fields.EncryptionAlgorithm.getSpecification().equals(fieldSpecification)) {
            this.setEncryptionAlgorithm((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = IssuedIdentityToken.builder();
        builder.setPolicyId(this.getPolicyId());
        builder.setTokenData(this.getTokenData());
        builder.setEncryptionAlgorithm(this.getEncryptionAlgorithm());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.PolicyId.getSpecification());
        builder.addField(Fields.TokenData.getSpecification());
        builder.addField(Fields.EncryptionAlgorithm.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("IssuedIdentityToken");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.IssuedIdentityTokenSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return IssuedIdentityToken.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends UserIdentityToken.Builder {
        private String policyId;
        private ByteString tokenData;
        private String encryptionAlgorithm;

        protected Builder() {
        }

        @Override
        public Builder setPolicyId(String string) {
            this.policyId = string;
            return this;
        }

        public Builder setTokenData(ByteString byteString) {
            this.tokenData = byteString;
            return this;
        }

        public Builder setEncryptionAlgorithm(String string) {
            this.encryptionAlgorithm = string;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
                this.setPolicyId((String)object);
                return this;
            }
            if (Fields.TokenData.getSpecification().equals(fieldSpecification)) {
                this.setTokenData((ByteString)object);
                return this;
            }
            if (Fields.EncryptionAlgorithm.getSpecification().equals(fieldSpecification)) {
                this.setEncryptionAlgorithm((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public IssuedIdentityToken build() {
            return new IssuedIdentityToken(this.policyId, this.tokenData, this.encryptionAlgorithm);
        }
    }

    public static enum Fields {
        PolicyId("PolicyId", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        TokenData("TokenData", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15")), -1),
        EncryptionAlgorithm("EncryptionAlgorithm", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

