/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=695")
public class HistoryUpdateResult
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.HistoryUpdateResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.HistoryUpdateResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.HistoryUpdateResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.HistoryUpdateResult;
    public static final StructureSpecification SPECIFICATION;
    private StatusCode statusCode;
    private StatusCode[] operationResults;
    private DiagnosticInfo[] diagnosticInfos;

    public HistoryUpdateResult() {
    }

    public HistoryUpdateResult(StatusCode statusCode, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.statusCode = statusCode;
        this.operationResults = statusCodeArray;
        this.diagnosticInfos = diagnosticInfoArray;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public StatusCode[] getOperationResults() {
        return this.operationResults;
    }

    public void setOperationResults(StatusCode[] statusCodeArray) {
        this.operationResults = statusCodeArray;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.diagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public HistoryUpdateResult clone() {
        HistoryUpdateResult historyUpdateResult = (HistoryUpdateResult)super.clone();
        historyUpdateResult.statusCode = StructureUtils.clone(this.statusCode);
        historyUpdateResult.operationResults = StructureUtils.clone(this.operationResults);
        historyUpdateResult.diagnosticInfos = StructureUtils.clone(this.diagnosticInfos);
        return historyUpdateResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryUpdateResult historyUpdateResult = (HistoryUpdateResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStatusCode(), historyUpdateResult.getStatusCode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getOperationResults(), historyUpdateResult.getOperationResults())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDiagnosticInfos(), historyUpdateResult.getDiagnosticInfos());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStatusCode(), this.getOperationResults(), this.getDiagnosticInfos());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            return this.getStatusCode();
        }
        if (Fields.OperationResults.getSpecification().equals(fieldSpecification)) {
            return this.getOperationResults();
        }
        if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            return this.getDiagnosticInfos();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            this.setStatusCode((StatusCode)object);
            return;
        }
        if (Fields.OperationResults.getSpecification().equals(fieldSpecification)) {
            this.setOperationResults((StatusCode[])object);
            return;
        }
        if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            this.setDiagnosticInfos((DiagnosticInfo[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = HistoryUpdateResult.builder();
        builder.setStatusCode(this.getStatusCode());
        builder.setOperationResults(this.getOperationResults());
        builder.setDiagnosticInfos(this.getDiagnosticInfos());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.StatusCode.getSpecification());
        builder.addField(Fields.OperationResults.getSpecification());
        builder.addField(Fields.DiagnosticInfos.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("HistoryUpdateResult");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.HistoryUpdateResultSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return HistoryUpdateResult.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private StatusCode statusCode;
        private StatusCode[] operationResults;
        private DiagnosticInfo[] diagnosticInfos;

        protected Builder() {
        }

        public Builder setStatusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setOperationResults(StatusCode[] statusCodeArray) {
            this.operationResults = statusCodeArray;
            return this;
        }

        public Builder setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
            this.diagnosticInfos = diagnosticInfoArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
                this.setStatusCode((StatusCode)object);
                return this;
            }
            if (Fields.OperationResults.getSpecification().equals(fieldSpecification)) {
                this.setOperationResults((StatusCode[])object);
                return this;
            }
            if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
                this.setDiagnosticInfos((DiagnosticInfo[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public HistoryUpdateResult build() {
            return new HistoryUpdateResult(this.statusCode, this.operationResults, this.diagnosticInfos);
        }
    }

    public static enum Fields {
        StatusCode("StatusCode", StatusCode.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), -1),
        OperationResults("OperationResults", StatusCode[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), 1),
        DiagnosticInfos("DiagnosticInfos", DiagnosticInfo[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=25")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

