/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=635")
public class HistoryReadValueId
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.HistoryReadValueId_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.HistoryReadValueId_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.HistoryReadValueId_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.HistoryReadValueId;
    public static final StructureSpecification SPECIFICATION;
    private NodeId nodeId;
    private String indexRange;
    private QualifiedName dataEncoding;
    private ByteString continuationPoint;

    public HistoryReadValueId() {
    }

    public HistoryReadValueId(NodeId nodeId, String string, QualifiedName qualifiedName, ByteString byteString) {
        this.nodeId = nodeId;
        this.indexRange = string;
        this.dataEncoding = qualifiedName;
        this.continuationPoint = byteString;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(NodeId nodeId) {
        this.nodeId = nodeId;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public void setIndexRange(String string) {
        this.indexRange = string;
    }

    public QualifiedName getDataEncoding() {
        return this.dataEncoding;
    }

    public void setDataEncoding(QualifiedName qualifiedName) {
        this.dataEncoding = qualifiedName;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    public void setContinuationPoint(ByteString byteString) {
        this.continuationPoint = byteString;
    }

    @Override
    public HistoryReadValueId clone() {
        HistoryReadValueId historyReadValueId = (HistoryReadValueId)super.clone();
        historyReadValueId.nodeId = StructureUtils.clone(this.nodeId);
        historyReadValueId.indexRange = StructureUtils.clone(this.indexRange);
        historyReadValueId.dataEncoding = StructureUtils.clone(this.dataEncoding);
        historyReadValueId.continuationPoint = StructureUtils.clone(this.continuationPoint);
        return historyReadValueId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryReadValueId historyReadValueId = (HistoryReadValueId)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNodeId(), historyReadValueId.getNodeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getIndexRange(), historyReadValueId.getIndexRange())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDataEncoding(), historyReadValueId.getDataEncoding())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getContinuationPoint(), historyReadValueId.getContinuationPoint());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getNodeId(), this.getIndexRange(), this.getDataEncoding(), this.getContinuationPoint());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
            return this.getNodeId();
        }
        if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
            return this.getIndexRange();
        }
        if (Fields.DataEncoding.getSpecification().equals(fieldSpecification)) {
            return this.getDataEncoding();
        }
        if (Fields.ContinuationPoint.getSpecification().equals(fieldSpecification)) {
            return this.getContinuationPoint();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
            this.setNodeId((NodeId)object);
            return;
        }
        if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
            this.setIndexRange((String)object);
            return;
        }
        if (Fields.DataEncoding.getSpecification().equals(fieldSpecification)) {
            this.setDataEncoding((QualifiedName)object);
            return;
        }
        if (Fields.ContinuationPoint.getSpecification().equals(fieldSpecification)) {
            this.setContinuationPoint((ByteString)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = HistoryReadValueId.builder();
        builder.setNodeId(this.getNodeId());
        builder.setIndexRange(this.getIndexRange());
        builder.setDataEncoding(this.getDataEncoding());
        builder.setContinuationPoint(this.getContinuationPoint());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.NodeId.getSpecification());
        builder.addField(Fields.IndexRange.getSpecification());
        builder.addField(Fields.DataEncoding.getSpecification());
        builder.addField(Fields.ContinuationPoint.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("HistoryReadValueId");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.HistoryReadValueIdSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return HistoryReadValueId.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId nodeId;
        private String indexRange;
        private QualifiedName dataEncoding;
        private ByteString continuationPoint;

        protected Builder() {
        }

        public Builder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setIndexRange(String string) {
            this.indexRange = string;
            return this;
        }

        public Builder setDataEncoding(QualifiedName qualifiedName) {
            this.dataEncoding = qualifiedName;
            return this;
        }

        public Builder setContinuationPoint(ByteString byteString) {
            this.continuationPoint = byteString;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
                this.setNodeId((NodeId)object);
                return this;
            }
            if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
                this.setIndexRange((String)object);
                return this;
            }
            if (Fields.DataEncoding.getSpecification().equals(fieldSpecification)) {
                this.setDataEncoding((QualifiedName)object);
                return this;
            }
            if (Fields.ContinuationPoint.getSpecification().equals(fieldSpecification)) {
                this.setContinuationPoint((ByteString)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public HistoryReadValueId build() {
            return new HistoryReadValueId(this.nodeId, this.indexRange, this.dataEncoding, this.continuationPoint);
        }
    }

    public static enum Fields {
        NodeId("NodeId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        IndexRange("IndexRange", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=291")), -1),
        DataEncoding("DataEncoding", QualifiedName.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=20")), -1),
        ContinuationPoint("ContinuationPoint", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=521")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

