/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=638")
public class HistoryReadResult
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.HistoryReadResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.HistoryReadResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.HistoryReadResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.HistoryReadResult;
    public static final StructureSpecification SPECIFICATION;
    private StatusCode statusCode;
    private ByteString continuationPoint;
    private ExtensionObject historyData;

    public HistoryReadResult() {
    }

    public HistoryReadResult(StatusCode statusCode, ByteString byteString, ExtensionObject extensionObject) {
        this.statusCode = statusCode;
        this.continuationPoint = byteString;
        this.historyData = extensionObject;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    public void setContinuationPoint(ByteString byteString) {
        this.continuationPoint = byteString;
    }

    public ExtensionObject getHistoryData() {
        return this.historyData;
    }

    public void setHistoryData(ExtensionObject extensionObject) {
        this.historyData = extensionObject;
    }

    @Override
    public HistoryReadResult clone() {
        HistoryReadResult historyReadResult = (HistoryReadResult)super.clone();
        historyReadResult.statusCode = StructureUtils.clone(this.statusCode);
        historyReadResult.continuationPoint = StructureUtils.clone(this.continuationPoint);
        historyReadResult.historyData = StructureUtils.clone(this.historyData);
        return historyReadResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryReadResult historyReadResult = (HistoryReadResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStatusCode(), historyReadResult.getStatusCode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getContinuationPoint(), historyReadResult.getContinuationPoint())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getHistoryData(), historyReadResult.getHistoryData());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStatusCode(), this.getContinuationPoint(), this.getHistoryData());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            return this.getStatusCode();
        }
        if (Fields.ContinuationPoint.getSpecification().equals(fieldSpecification)) {
            return this.getContinuationPoint();
        }
        if (Fields.HistoryData.getSpecification().equals(fieldSpecification)) {
            return this.getHistoryData();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            this.setStatusCode((StatusCode)object);
            return;
        }
        if (Fields.ContinuationPoint.getSpecification().equals(fieldSpecification)) {
            this.setContinuationPoint((ByteString)object);
            return;
        }
        if (Fields.HistoryData.getSpecification().equals(fieldSpecification)) {
            this.setHistoryData((ExtensionObject)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = HistoryReadResult.builder();
        builder.setStatusCode(this.getStatusCode());
        builder.setContinuationPoint(this.getContinuationPoint());
        builder.setHistoryData(this.getHistoryData());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.StatusCode.getSpecification());
        builder.addField(Fields.ContinuationPoint.getSpecification());
        builder.addField(Fields.HistoryData.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("HistoryReadResult");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.HistoryReadResultSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return HistoryReadResult.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private StatusCode statusCode;
        private ByteString continuationPoint;
        private ExtensionObject historyData;

        protected Builder() {
        }

        public Builder setStatusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setContinuationPoint(ByteString byteString) {
            this.continuationPoint = byteString;
            return this;
        }

        public Builder setHistoryData(ExtensionObject extensionObject) {
            this.historyData = extensionObject;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
                this.setStatusCode((StatusCode)object);
                return this;
            }
            if (Fields.ContinuationPoint.getSpecification().equals(fieldSpecification)) {
                this.setContinuationPoint((ByteString)object);
                return this;
            }
            if (Fields.HistoryData.getSpecification().equals(fieldSpecification)) {
                this.setHistoryData((ExtensionObject)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public HistoryReadResult build() {
            return new HistoryReadResult(this.statusCode, this.continuationPoint, this.historyData);
        }
    }

    public static enum Fields {
        StatusCode("StatusCode", StatusCode.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), -1),
        ContinuationPoint("ContinuationPoint", ByteString.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=521")), -1),
        HistoryData("HistoryData", Structure.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=22")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

