/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.HistoryData;
import com.prosysopc.ua.stack.core.ModificationInfo;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11217")
public class HistoryModifiedData
extends HistoryData {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.HistoryModifiedData_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.HistoryModifiedData_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.HistoryModifiedData_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.HistoryModifiedData;
    public static final StructureSpecification SPECIFICATION;
    private ModificationInfo[] modificationInfos;

    public HistoryModifiedData() {
    }

    public HistoryModifiedData(ModificationInfo[] modificationInfoArray) {
        this.modificationInfos = modificationInfoArray;
    }

    public HistoryModifiedData(DataValue[] dataValueArray, ModificationInfo[] modificationInfoArray) {
        super(dataValueArray);
        this.modificationInfos = modificationInfoArray;
    }

    public ModificationInfo[] getModificationInfos() {
        return this.modificationInfos;
    }

    public void setModificationInfos(ModificationInfo[] modificationInfoArray) {
        this.modificationInfos = modificationInfoArray;
    }

    @Override
    public HistoryModifiedData clone() {
        HistoryModifiedData historyModifiedData = (HistoryModifiedData)super.clone();
        historyModifiedData.modificationInfos = StructureUtils.clone(this.modificationInfos);
        return historyModifiedData;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryModifiedData historyModifiedData = (HistoryModifiedData)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getDataValues(), historyModifiedData.getDataValues())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getModificationInfos(), historyModifiedData.getModificationInfos());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getDataValues(), this.getModificationInfos());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.DataValues.getSpecification().equals(fieldSpecification)) {
            return this.getDataValues();
        }
        if (Fields.ModificationInfos.getSpecification().equals(fieldSpecification)) {
            return this.getModificationInfos();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.DataValues.getSpecification().equals(fieldSpecification)) {
            this.setDataValues((DataValue[])object);
            return;
        }
        if (Fields.ModificationInfos.getSpecification().equals(fieldSpecification)) {
            this.setModificationInfos((ModificationInfo[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = HistoryModifiedData.builder();
        builder.setDataValues(this.getDataValues());
        builder.setModificationInfos(this.getModificationInfos());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.DataValues.getSpecification());
        builder.addField(Fields.ModificationInfos.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("HistoryModifiedData");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.HistoryModifiedDataSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return HistoryModifiedData.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends HistoryData.Builder {
        private DataValue[] dataValues;
        private ModificationInfo[] modificationInfos;

        protected Builder() {
        }

        @Override
        public Builder setDataValues(DataValue[] dataValueArray) {
            this.dataValues = dataValueArray;
            return this;
        }

        public Builder setModificationInfos(ModificationInfo[] modificationInfoArray) {
            this.modificationInfos = modificationInfoArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.DataValues.getSpecification().equals(fieldSpecification)) {
                this.setDataValues((DataValue[])object);
                return this;
            }
            if (Fields.ModificationInfos.getSpecification().equals(fieldSpecification)) {
                this.setModificationInfos((ModificationInfo[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public HistoryModifiedData build() {
            return new HistoryModifiedData(this.dataValues, this.modificationInfos);
        }
    }

    public static enum Fields {
        DataValues("DataValues", DataValue[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=23")), 1),
        ModificationInfos("ModificationInfos", ModificationInfo[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11216")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

