/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=429")
public class GetEndpointsResponse
extends AbstractStructure
implements ServiceResponse {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.GetEndpointsResponse_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.GetEndpointsResponse_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.GetEndpointsResponse_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.GetEndpointsResponse;
    public static final StructureSpecification SPECIFICATION;
    private ResponseHeader responseHeader;
    private EndpointDescription[] endpoints;

    public GetEndpointsResponse() {
    }

    public GetEndpointsResponse(ResponseHeader responseHeader, EndpointDescription[] endpointDescriptionArray) {
        this.responseHeader = responseHeader;
        this.endpoints = endpointDescriptionArray;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.responseHeader = responseHeader;
    }

    public EndpointDescription[] getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(EndpointDescription[] endpointDescriptionArray) {
        this.endpoints = endpointDescriptionArray;
    }

    @Override
    public GetEndpointsResponse clone() {
        GetEndpointsResponse getEndpointsResponse = (GetEndpointsResponse)super.clone();
        getEndpointsResponse.responseHeader = StructureUtils.clone(this.responseHeader);
        getEndpointsResponse.endpoints = StructureUtils.clone(this.endpoints);
        return getEndpointsResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GetEndpointsResponse getEndpointsResponse = (GetEndpointsResponse)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getResponseHeader(), getEndpointsResponse.getResponseHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getEndpoints(), getEndpointsResponse.getEndpoints());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getResponseHeader(), this.getEndpoints());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            return this.getResponseHeader();
        }
        if (Fields.Endpoints.getSpecification().equals(fieldSpecification)) {
            return this.getEndpoints();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            this.setResponseHeader((ResponseHeader)object);
            return;
        }
        if (Fields.Endpoints.getSpecification().equals(fieldSpecification)) {
            this.setEndpoints((EndpointDescription[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = GetEndpointsResponse.builder();
        builder.setResponseHeader(this.getResponseHeader());
        builder.setEndpoints(this.getEndpoints());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ResponseHeader.getSpecification());
        builder.addField(Fields.Endpoints.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("GetEndpointsResponse");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.GetEndpointsResponseSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return GetEndpointsResponse.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ResponseHeader responseHeader;
        private EndpointDescription[] endpoints;

        protected Builder() {
        }

        public Builder setResponseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return this;
        }

        public Builder setEndpoints(EndpointDescription[] endpointDescriptionArray) {
            this.endpoints = endpointDescriptionArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
                this.setResponseHeader((ResponseHeader)object);
                return this;
            }
            if (Fields.Endpoints.getSpecification().equals(fieldSpecification)) {
                this.setEndpoints((EndpointDescription[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public GetEndpointsResponse build() {
            return new GetEndpointsResponse(this.responseHeader, this.endpoints);
        }
    }

    public static enum Fields {
        ResponseHeader("ResponseHeader", ResponseHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=392")), -1),
        Endpoints("Endpoints", EndpointDescription[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=312")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

