/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.GetEndpointsResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=426")
public class GetEndpointsRequest
extends AbstractStructure
implements ServiceRequest<GetEndpointsResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.GetEndpointsRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.GetEndpointsRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.GetEndpointsRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.GetEndpointsRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private String endpointUrl;
    private String[] localeIds;
    private String[] profileUris;

    public GetEndpointsRequest() {
    }

    public GetEndpointsRequest(RequestHeader requestHeader, String string, String[] stringArray, String[] stringArray2) {
        this.requestHeader = requestHeader;
        this.endpointUrl = string;
        this.localeIds = stringArray;
        this.profileUris = stringArray2;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(String string) {
        this.endpointUrl = string;
    }

    public String[] getLocaleIds() {
        return this.localeIds;
    }

    public void setLocaleIds(String[] stringArray) {
        this.localeIds = stringArray;
    }

    public String[] getProfileUris() {
        return this.profileUris;
    }

    public void setProfileUris(String[] stringArray) {
        this.profileUris = stringArray;
    }

    @Override
    public GetEndpointsRequest clone() {
        GetEndpointsRequest getEndpointsRequest = (GetEndpointsRequest)super.clone();
        getEndpointsRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        getEndpointsRequest.endpointUrl = StructureUtils.clone(this.endpointUrl);
        getEndpointsRequest.localeIds = StructureUtils.clone(this.localeIds);
        getEndpointsRequest.profileUris = StructureUtils.clone(this.profileUris);
        return getEndpointsRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GetEndpointsRequest getEndpointsRequest = (GetEndpointsRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), getEndpointsRequest.getRequestHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getEndpointUrl(), getEndpointsRequest.getEndpointUrl())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getLocaleIds(), getEndpointsRequest.getLocaleIds())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getProfileUris(), getEndpointsRequest.getProfileUris());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getEndpointUrl(), this.getLocaleIds(), this.getProfileUris());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.EndpointUrl.getSpecification().equals(fieldSpecification)) {
            return this.getEndpointUrl();
        }
        if (Fields.LocaleIds.getSpecification().equals(fieldSpecification)) {
            return this.getLocaleIds();
        }
        if (Fields.ProfileUris.getSpecification().equals(fieldSpecification)) {
            return this.getProfileUris();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.EndpointUrl.getSpecification().equals(fieldSpecification)) {
            this.setEndpointUrl((String)object);
            return;
        }
        if (Fields.LocaleIds.getSpecification().equals(fieldSpecification)) {
            this.setLocaleIds((String[])object);
            return;
        }
        if (Fields.ProfileUris.getSpecification().equals(fieldSpecification)) {
            this.setProfileUris((String[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = GetEndpointsRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setEndpointUrl(this.getEndpointUrl());
        builder.setLocaleIds(this.getLocaleIds());
        builder.setProfileUris(this.getProfileUris());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.EndpointUrl.getSpecification());
        builder.addField(Fields.LocaleIds.getSpecification());
        builder.addField(Fields.ProfileUris.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("GetEndpointsRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.GetEndpointsRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return GetEndpointsRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private String endpointUrl;
        private String[] localeIds;
        private String[] profileUris;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setEndpointUrl(String string) {
            this.endpointUrl = string;
            return this;
        }

        public Builder setLocaleIds(String[] stringArray) {
            this.localeIds = stringArray;
            return this;
        }

        public Builder setProfileUris(String[] stringArray) {
            this.profileUris = stringArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.EndpointUrl.getSpecification().equals(fieldSpecification)) {
                this.setEndpointUrl((String)object);
                return this;
            }
            if (Fields.LocaleIds.getSpecification().equals(fieldSpecification)) {
                this.setLocaleIds((String[])object);
                return this;
            }
            if (Fields.ProfileUris.getSpecification().equals(fieldSpecification)) {
                this.setProfileUris((String[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public GetEndpointsRequest build() {
            return new GetEndpointsRequest(this.requestHeader, this.endpointUrl, this.localeIds, this.profileUris);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        EndpointUrl("EndpointUrl", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        LocaleIds("LocaleIds", String[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=295")), 1),
        ProfileUris("ProfileUris", String[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

