/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17606")
public class GenericAttributeValue
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.GenericAttributeValue_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.GenericAttributeValue_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.GenericAttributeValue_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.GenericAttributeValue;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger attributeId;
    private Object value;

    public GenericAttributeValue() {
    }

    public GenericAttributeValue(UnsignedInteger unsignedInteger, Object object) {
        this.attributeId = unsignedInteger;
        this.value = object;
    }

    public UnsignedInteger getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(UnsignedInteger unsignedInteger) {
        this.attributeId = unsignedInteger;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    @Override
    public GenericAttributeValue clone() {
        GenericAttributeValue genericAttributeValue = (GenericAttributeValue)super.clone();
        genericAttributeValue.attributeId = StructureUtils.clone(this.attributeId);
        genericAttributeValue.value = StructureUtils.clone(this.value);
        return genericAttributeValue;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GenericAttributeValue genericAttributeValue = (GenericAttributeValue)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getAttributeId(), genericAttributeValue.getAttributeId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getValue(), genericAttributeValue.getValue());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getAttributeId(), this.getValue());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
            return this.getAttributeId();
        }
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            return this.getValue();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
            this.setAttributeId((UnsignedInteger)object);
            return;
        }
        if (Fields.Value.getSpecification().equals(fieldSpecification)) {
            this.setValue(object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = GenericAttributeValue.builder();
        builder.setAttributeId(this.getAttributeId());
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.AttributeId.getSpecification());
        builder.addField(Fields.Value.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("GenericAttributeValue");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.GenericAttributeValueSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return GenericAttributeValue.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private UnsignedInteger attributeId;
        private Object value;

        protected Builder() {
        }

        public Builder setAttributeId(UnsignedInteger unsignedInteger) {
            this.attributeId = unsignedInteger;
            return this;
        }

        public Builder setValue(Object object) {
            this.value = object;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
                this.setAttributeId((UnsignedInteger)object);
                return this;
            }
            if (Fields.Value.getSpecification().equals(fieldSpecification)) {
                this.setValue(object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public GenericAttributeValue build() {
            return new GenericAttributeValue(this.attributeId, this.value);
        }
    }

    public static enum Fields {
        AttributeId("AttributeId", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=288")), -1),
        Value("Value", Object.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=24")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

