/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.EventFieldList;
import com.prosysopc.ua.stack.core.NotificationData;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=914")
public class EventNotificationList
extends NotificationData {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EventNotificationList_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EventNotificationList_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EventNotificationList_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EventNotificationList;
    public static final StructureSpecification SPECIFICATION;
    private EventFieldList[] events;

    public EventNotificationList() {
    }

    public EventNotificationList(EventFieldList[] eventFieldListArray) {
        this.events = eventFieldListArray;
    }

    public EventFieldList[] getEvents() {
        return this.events;
    }

    public void setEvents(EventFieldList[] eventFieldListArray) {
        this.events = eventFieldListArray;
    }

    @Override
    public EventNotificationList clone() {
        EventNotificationList eventNotificationList = (EventNotificationList)super.clone();
        eventNotificationList.events = StructureUtils.clone(this.events);
        return eventNotificationList;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventNotificationList eventNotificationList = (EventNotificationList)object;
        return StructureUtils.scalarOrArrayEquals(this.getEvents(), eventNotificationList.getEvents());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getEvents());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Events.getSpecification().equals(fieldSpecification)) {
            return this.getEvents();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Events.getSpecification().equals(fieldSpecification)) {
            this.setEvents((EventFieldList[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EventNotificationList.builder();
        builder.setEvents(this.getEvents());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Events.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("EventNotificationList");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.EventNotificationListSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return EventNotificationList.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends NotificationData.Builder {
        private EventFieldList[] events;

        protected Builder() {
        }

        public Builder setEvents(EventFieldList[] eventFieldListArray) {
            this.events = eventFieldListArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Events.getSpecification().equals(fieldSpecification)) {
                this.setEvents((EventFieldList[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public EventNotificationList build() {
            return new EventNotificationList(this.events);
        }
    }

    public static enum Fields {
        Events("Events", EventFieldList[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=917")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

