/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ContentFilter;
import com.prosysopc.ua.stack.core.MonitoringFilter;
import com.prosysopc.ua.stack.core.SimpleAttributeOperand;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=725")
public class EventFilter
extends MonitoringFilter {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EventFilter_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EventFilter_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EventFilter_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EventFilter;
    public static final StructureSpecification SPECIFICATION;
    private SimpleAttributeOperand[] selectClauses;
    private ContentFilter whereClause;

    public EventFilter() {
    }

    public EventFilter(SimpleAttributeOperand[] simpleAttributeOperandArray, ContentFilter contentFilter) {
        this.selectClauses = simpleAttributeOperandArray;
        this.whereClause = contentFilter;
    }

    public SimpleAttributeOperand[] getSelectClauses() {
        return this.selectClauses;
    }

    public void setSelectClauses(SimpleAttributeOperand[] simpleAttributeOperandArray) {
        this.selectClauses = simpleAttributeOperandArray;
    }

    public ContentFilter getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(ContentFilter contentFilter) {
        this.whereClause = contentFilter;
    }

    @Override
    public EventFilter clone() {
        EventFilter eventFilter = (EventFilter)super.clone();
        eventFilter.selectClauses = StructureUtils.clone(this.selectClauses);
        eventFilter.whereClause = StructureUtils.clone(this.whereClause);
        return eventFilter;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EventFilter eventFilter = (EventFilter)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getSelectClauses(), eventFilter.getSelectClauses())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getWhereClause(), eventFilter.getWhereClause());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getSelectClauses(), this.getWhereClause());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.SelectClauses.getSpecification().equals(fieldSpecification)) {
            return this.getSelectClauses();
        }
        if (Fields.WhereClause.getSpecification().equals(fieldSpecification)) {
            return this.getWhereClause();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.SelectClauses.getSpecification().equals(fieldSpecification)) {
            this.setSelectClauses((SimpleAttributeOperand[])object);
            return;
        }
        if (Fields.WhereClause.getSpecification().equals(fieldSpecification)) {
            this.setWhereClause((ContentFilter)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EventFilter.builder();
        builder.setSelectClauses(this.getSelectClauses());
        builder.setWhereClause(this.getWhereClause());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.SelectClauses.getSpecification());
        builder.addField(Fields.WhereClause.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("EventFilter");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.EventFilterSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return EventFilter.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends MonitoringFilter.Builder {
        private SimpleAttributeOperand[] selectClauses;
        private ContentFilter whereClause;

        protected Builder() {
        }

        public Builder setSelectClauses(SimpleAttributeOperand[] simpleAttributeOperandArray) {
            this.selectClauses = simpleAttributeOperandArray;
            return this;
        }

        public Builder setWhereClause(ContentFilter contentFilter) {
            this.whereClause = contentFilter;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.SelectClauses.getSpecification().equals(fieldSpecification)) {
                this.setSelectClauses((SimpleAttributeOperand[])object);
                return this;
            }
            if (Fields.WhereClause.getSpecification().equals(fieldSpecification)) {
                this.setWhereClause((ContentFilter)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public EventFilter build() {
            return new EventFilter(this.selectClauses, this.whereClause);
        }
    }

    public static enum Fields {
        SelectClauses("SelectClauses", SimpleAttributeOperand[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=601")), 1),
        WhereClause("WhereClause", ContentFilter.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=586")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

