/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.DataTypeDefinition;
import com.prosysopc.ua.stack.core.EnumField;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=100")
public class EnumDefinition
extends DataTypeDefinition {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EnumDefinition_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EnumDefinition_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EnumDefinition_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EnumDefinition;
    public static final StructureSpecification SPECIFICATION;
    private EnumField[] fields;

    public EnumDefinition() {
    }

    public EnumDefinition(EnumField[] enumFieldArray) {
        this.fields = enumFieldArray;
    }

    public EnumField[] getFields() {
        return this.fields;
    }

    public void setFields(EnumField[] enumFieldArray) {
        this.fields = enumFieldArray;
    }

    @Override
    public EnumDefinition clone() {
        EnumDefinition enumDefinition = (EnumDefinition)super.clone();
        enumDefinition.fields = StructureUtils.clone(this.fields);
        return enumDefinition;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EnumDefinition enumDefinition = (EnumDefinition)object;
        return StructureUtils.scalarOrArrayEquals(this.getFields(), enumDefinition.getFields());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getFields());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Fields.getSpecification().equals(fieldSpecification)) {
            return this.getFields();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Fields.getSpecification().equals(fieldSpecification)) {
            this.setFields((EnumField[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EnumDefinition.builder();
        builder.setFields(this.getFields());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Fields.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("EnumDefinition");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.EnumDefinitionSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return EnumDefinition.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends DataTypeDefinition.Builder {
        private EnumField[] fields;

        protected Builder() {
        }

        public Builder setFields(EnumField[] enumFieldArray) {
            this.fields = enumFieldArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Fields.getSpecification().equals(fieldSpecification)) {
                this.setFields((EnumField[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public EnumDefinition build() {
            return new EnumDefinition(this.fields);
        }
    }

    public static enum Fields {
        Fields("Fields", EnumField[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=102")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

