/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15528")
public class EndpointType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EndpointType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EndpointType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EndpointType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EndpointType;
    public static final StructureSpecification SPECIFICATION;
    private String endpointUrl;
    private MessageSecurityMode securityMode;
    private String securityPolicyUri;
    private String transportProfileUri;

    public EndpointType() {
    }

    public EndpointType(String string, MessageSecurityMode messageSecurityMode, String string2, String string3) {
        this.endpointUrl = string;
        this.securityMode = messageSecurityMode;
        this.securityPolicyUri = string2;
        this.transportProfileUri = string3;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(String string) {
        this.endpointUrl = string;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        this.securityMode = messageSecurityMode;
    }

    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public void setSecurityPolicyUri(String string) {
        this.securityPolicyUri = string;
    }

    public String getTransportProfileUri() {
        return this.transportProfileUri;
    }

    public void setTransportProfileUri(String string) {
        this.transportProfileUri = string;
    }

    @Override
    public EndpointType clone() {
        EndpointType endpointType = (EndpointType)super.clone();
        endpointType.endpointUrl = StructureUtils.clone(this.endpointUrl);
        endpointType.securityMode = StructureUtils.clone(this.securityMode);
        endpointType.securityPolicyUri = StructureUtils.clone(this.securityPolicyUri);
        endpointType.transportProfileUri = StructureUtils.clone(this.transportProfileUri);
        return endpointType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EndpointType endpointType = (EndpointType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getEndpointUrl(), endpointType.getEndpointUrl())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecurityMode(), endpointType.getSecurityMode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSecurityPolicyUri(), endpointType.getSecurityPolicyUri())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getTransportProfileUri(), endpointType.getTransportProfileUri());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getEndpointUrl(), this.getSecurityMode(), this.getSecurityPolicyUri(), this.getTransportProfileUri());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.EndpointUrl.getSpecification().equals(fieldSpecification)) {
            return this.getEndpointUrl();
        }
        if (Fields.SecurityMode.getSpecification().equals(fieldSpecification)) {
            return this.getSecurityMode();
        }
        if (Fields.SecurityPolicyUri.getSpecification().equals(fieldSpecification)) {
            return this.getSecurityPolicyUri();
        }
        if (Fields.TransportProfileUri.getSpecification().equals(fieldSpecification)) {
            return this.getTransportProfileUri();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.EndpointUrl.getSpecification().equals(fieldSpecification)) {
            this.setEndpointUrl((String)object);
            return;
        }
        if (Fields.SecurityMode.getSpecification().equals(fieldSpecification)) {
            this.setSecurityMode((MessageSecurityMode)object);
            return;
        }
        if (Fields.SecurityPolicyUri.getSpecification().equals(fieldSpecification)) {
            this.setSecurityPolicyUri((String)object);
            return;
        }
        if (Fields.TransportProfileUri.getSpecification().equals(fieldSpecification)) {
            this.setTransportProfileUri((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EndpointType.builder();
        builder.setEndpointUrl(this.getEndpointUrl());
        builder.setSecurityMode(this.getSecurityMode());
        builder.setSecurityPolicyUri(this.getSecurityPolicyUri());
        builder.setTransportProfileUri(this.getTransportProfileUri());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.EndpointUrl.getSpecification());
        builder.addField(Fields.SecurityMode.getSpecification());
        builder.addField(Fields.SecurityPolicyUri.getSpecification());
        builder.addField(Fields.TransportProfileUri.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("EndpointType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.EndpointTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return EndpointType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private String endpointUrl;
        private MessageSecurityMode securityMode;
        private String securityPolicyUri;
        private String transportProfileUri;

        protected Builder() {
        }

        public Builder setEndpointUrl(String string) {
            this.endpointUrl = string;
            return this;
        }

        public Builder setSecurityMode(MessageSecurityMode messageSecurityMode) {
            this.securityMode = messageSecurityMode;
            return this;
        }

        public Builder setSecurityPolicyUri(String string) {
            this.securityPolicyUri = string;
            return this;
        }

        public Builder setTransportProfileUri(String string) {
            this.transportProfileUri = string;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.EndpointUrl.getSpecification().equals(fieldSpecification)) {
                this.setEndpointUrl((String)object);
                return this;
            }
            if (Fields.SecurityMode.getSpecification().equals(fieldSpecification)) {
                this.setSecurityMode((MessageSecurityMode)object);
                return this;
            }
            if (Fields.SecurityPolicyUri.getSpecification().equals(fieldSpecification)) {
                this.setSecurityPolicyUri((String)object);
                return this;
            }
            if (Fields.TransportProfileUri.getSpecification().equals(fieldSpecification)) {
                this.setTransportProfileUri((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public EndpointType build() {
            return new EndpointType(this.endpointUrl, this.securityMode, this.securityPolicyUri, this.transportProfileUri);
        }
    }

    public static enum Fields {
        EndpointUrl("EndpointUrl", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        SecurityMode("SecurityMode", MessageSecurityMode.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=302")), -1),
        SecurityPolicyUri("SecurityPolicyUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        TransportProfileUri("TransportProfileUri", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

