/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=331")
public class EndpointConfiguration
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.EndpointConfiguration_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.EndpointConfiguration_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.EndpointConfiguration_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.EndpointConfiguration;
    public static final StructureSpecification SPECIFICATION;
    private Integer operationTimeout;
    private Boolean useBinaryEncoding;
    private Integer maxStringLength;
    private Integer maxByteStringLength;
    private Integer maxArrayLength;
    private Integer maxMessageSize;
    private Integer maxBufferSize;
    private Integer channelLifetime;
    private Integer securityTokenLifetime;

    public EndpointConfiguration() {
    }

    public EndpointConfiguration(Integer n2, Boolean bl, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, Integer n8, Integer n9) {
        this.operationTimeout = n2;
        this.useBinaryEncoding = bl;
        this.maxStringLength = n3;
        this.maxByteStringLength = n4;
        this.maxArrayLength = n5;
        this.maxMessageSize = n6;
        this.maxBufferSize = n7;
        this.channelLifetime = n8;
        this.securityTokenLifetime = n9;
    }

    public Integer getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(Integer n2) {
        this.operationTimeout = n2;
    }

    public Boolean getUseBinaryEncoding() {
        return this.useBinaryEncoding;
    }

    public void setUseBinaryEncoding(Boolean bl) {
        this.useBinaryEncoding = bl;
    }

    public Integer getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(Integer n2) {
        this.maxStringLength = n2;
    }

    public Integer getMaxByteStringLength() {
        return this.maxByteStringLength;
    }

    public void setMaxByteStringLength(Integer n2) {
        this.maxByteStringLength = n2;
    }

    public Integer getMaxArrayLength() {
        return this.maxArrayLength;
    }

    public void setMaxArrayLength(Integer n2) {
        this.maxArrayLength = n2;
    }

    public Integer getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(Integer n2) {
        this.maxMessageSize = n2;
    }

    public Integer getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public void setMaxBufferSize(Integer n2) {
        this.maxBufferSize = n2;
    }

    public Integer getChannelLifetime() {
        return this.channelLifetime;
    }

    public void setChannelLifetime(Integer n2) {
        this.channelLifetime = n2;
    }

    public Integer getSecurityTokenLifetime() {
        return this.securityTokenLifetime;
    }

    public void setSecurityTokenLifetime(Integer n2) {
        this.securityTokenLifetime = n2;
    }

    @Override
    public EndpointConfiguration clone() {
        EndpointConfiguration endpointConfiguration = (EndpointConfiguration)super.clone();
        endpointConfiguration.operationTimeout = StructureUtils.clone(this.operationTimeout);
        endpointConfiguration.useBinaryEncoding = StructureUtils.clone(this.useBinaryEncoding);
        endpointConfiguration.maxStringLength = StructureUtils.clone(this.maxStringLength);
        endpointConfiguration.maxByteStringLength = StructureUtils.clone(this.maxByteStringLength);
        endpointConfiguration.maxArrayLength = StructureUtils.clone(this.maxArrayLength);
        endpointConfiguration.maxMessageSize = StructureUtils.clone(this.maxMessageSize);
        endpointConfiguration.maxBufferSize = StructureUtils.clone(this.maxBufferSize);
        endpointConfiguration.channelLifetime = StructureUtils.clone(this.channelLifetime);
        endpointConfiguration.securityTokenLifetime = StructureUtils.clone(this.securityTokenLifetime);
        return endpointConfiguration;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EndpointConfiguration endpointConfiguration = (EndpointConfiguration)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getOperationTimeout(), endpointConfiguration.getOperationTimeout())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getUseBinaryEncoding(), endpointConfiguration.getUseBinaryEncoding())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getMaxStringLength(), endpointConfiguration.getMaxStringLength())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getMaxByteStringLength(), endpointConfiguration.getMaxByteStringLength())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getMaxArrayLength(), endpointConfiguration.getMaxArrayLength())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getMaxMessageSize(), endpointConfiguration.getMaxMessageSize())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getMaxBufferSize(), endpointConfiguration.getMaxBufferSize())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getChannelLifetime(), endpointConfiguration.getChannelLifetime())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getSecurityTokenLifetime(), endpointConfiguration.getSecurityTokenLifetime());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getOperationTimeout(), this.getUseBinaryEncoding(), this.getMaxStringLength(), this.getMaxByteStringLength(), this.getMaxArrayLength(), this.getMaxMessageSize(), this.getMaxBufferSize(), this.getChannelLifetime(), this.getSecurityTokenLifetime());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.OperationTimeout.getSpecification().equals(fieldSpecification)) {
            return this.getOperationTimeout();
        }
        if (Fields.UseBinaryEncoding.getSpecification().equals(fieldSpecification)) {
            return this.getUseBinaryEncoding();
        }
        if (Fields.MaxStringLength.getSpecification().equals(fieldSpecification)) {
            return this.getMaxStringLength();
        }
        if (Fields.MaxByteStringLength.getSpecification().equals(fieldSpecification)) {
            return this.getMaxByteStringLength();
        }
        if (Fields.MaxArrayLength.getSpecification().equals(fieldSpecification)) {
            return this.getMaxArrayLength();
        }
        if (Fields.MaxMessageSize.getSpecification().equals(fieldSpecification)) {
            return this.getMaxMessageSize();
        }
        if (Fields.MaxBufferSize.getSpecification().equals(fieldSpecification)) {
            return this.getMaxBufferSize();
        }
        if (Fields.ChannelLifetime.getSpecification().equals(fieldSpecification)) {
            return this.getChannelLifetime();
        }
        if (Fields.SecurityTokenLifetime.getSpecification().equals(fieldSpecification)) {
            return this.getSecurityTokenLifetime();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.OperationTimeout.getSpecification().equals(fieldSpecification)) {
            this.setOperationTimeout((Integer)object);
            return;
        }
        if (Fields.UseBinaryEncoding.getSpecification().equals(fieldSpecification)) {
            this.setUseBinaryEncoding((Boolean)object);
            return;
        }
        if (Fields.MaxStringLength.getSpecification().equals(fieldSpecification)) {
            this.setMaxStringLength((Integer)object);
            return;
        }
        if (Fields.MaxByteStringLength.getSpecification().equals(fieldSpecification)) {
            this.setMaxByteStringLength((Integer)object);
            return;
        }
        if (Fields.MaxArrayLength.getSpecification().equals(fieldSpecification)) {
            this.setMaxArrayLength((Integer)object);
            return;
        }
        if (Fields.MaxMessageSize.getSpecification().equals(fieldSpecification)) {
            this.setMaxMessageSize((Integer)object);
            return;
        }
        if (Fields.MaxBufferSize.getSpecification().equals(fieldSpecification)) {
            this.setMaxBufferSize((Integer)object);
            return;
        }
        if (Fields.ChannelLifetime.getSpecification().equals(fieldSpecification)) {
            this.setChannelLifetime((Integer)object);
            return;
        }
        if (Fields.SecurityTokenLifetime.getSpecification().equals(fieldSpecification)) {
            this.setSecurityTokenLifetime((Integer)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = EndpointConfiguration.builder();
        builder.setOperationTimeout(this.getOperationTimeout());
        builder.setUseBinaryEncoding(this.getUseBinaryEncoding());
        builder.setMaxStringLength(this.getMaxStringLength());
        builder.setMaxByteStringLength(this.getMaxByteStringLength());
        builder.setMaxArrayLength(this.getMaxArrayLength());
        builder.setMaxMessageSize(this.getMaxMessageSize());
        builder.setMaxBufferSize(this.getMaxBufferSize());
        builder.setChannelLifetime(this.getChannelLifetime());
        builder.setSecurityTokenLifetime(this.getSecurityTokenLifetime());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.OperationTimeout.getSpecification());
        builder.addField(Fields.UseBinaryEncoding.getSpecification());
        builder.addField(Fields.MaxStringLength.getSpecification());
        builder.addField(Fields.MaxByteStringLength.getSpecification());
        builder.addField(Fields.MaxArrayLength.getSpecification());
        builder.addField(Fields.MaxMessageSize.getSpecification());
        builder.addField(Fields.MaxBufferSize.getSpecification());
        builder.addField(Fields.ChannelLifetime.getSpecification());
        builder.addField(Fields.SecurityTokenLifetime.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("EndpointConfiguration");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.EndpointConfigurationSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return EndpointConfiguration.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Integer operationTimeout;
        private Boolean useBinaryEncoding;
        private Integer maxStringLength;
        private Integer maxByteStringLength;
        private Integer maxArrayLength;
        private Integer maxMessageSize;
        private Integer maxBufferSize;
        private Integer channelLifetime;
        private Integer securityTokenLifetime;

        protected Builder() {
        }

        public Builder setOperationTimeout(Integer n2) {
            this.operationTimeout = n2;
            return this;
        }

        public Builder setUseBinaryEncoding(Boolean bl) {
            this.useBinaryEncoding = bl;
            return this;
        }

        public Builder setMaxStringLength(Integer n2) {
            this.maxStringLength = n2;
            return this;
        }

        public Builder setMaxByteStringLength(Integer n2) {
            this.maxByteStringLength = n2;
            return this;
        }

        public Builder setMaxArrayLength(Integer n2) {
            this.maxArrayLength = n2;
            return this;
        }

        public Builder setMaxMessageSize(Integer n2) {
            this.maxMessageSize = n2;
            return this;
        }

        public Builder setMaxBufferSize(Integer n2) {
            this.maxBufferSize = n2;
            return this;
        }

        public Builder setChannelLifetime(Integer n2) {
            this.channelLifetime = n2;
            return this;
        }

        public Builder setSecurityTokenLifetime(Integer n2) {
            this.securityTokenLifetime = n2;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.OperationTimeout.getSpecification().equals(fieldSpecification)) {
                this.setOperationTimeout((Integer)object);
                return this;
            }
            if (Fields.UseBinaryEncoding.getSpecification().equals(fieldSpecification)) {
                this.setUseBinaryEncoding((Boolean)object);
                return this;
            }
            if (Fields.MaxStringLength.getSpecification().equals(fieldSpecification)) {
                this.setMaxStringLength((Integer)object);
                return this;
            }
            if (Fields.MaxByteStringLength.getSpecification().equals(fieldSpecification)) {
                this.setMaxByteStringLength((Integer)object);
                return this;
            }
            if (Fields.MaxArrayLength.getSpecification().equals(fieldSpecification)) {
                this.setMaxArrayLength((Integer)object);
                return this;
            }
            if (Fields.MaxMessageSize.getSpecification().equals(fieldSpecification)) {
                this.setMaxMessageSize((Integer)object);
                return this;
            }
            if (Fields.MaxBufferSize.getSpecification().equals(fieldSpecification)) {
                this.setMaxBufferSize((Integer)object);
                return this;
            }
            if (Fields.ChannelLifetime.getSpecification().equals(fieldSpecification)) {
                this.setChannelLifetime((Integer)object);
                return this;
            }
            if (Fields.SecurityTokenLifetime.getSpecification().equals(fieldSpecification)) {
                this.setSecurityTokenLifetime((Integer)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public EndpointConfiguration build() {
            return new EndpointConfiguration(this.operationTimeout, this.useBinaryEncoding, this.maxStringLength, this.maxByteStringLength, this.maxArrayLength, this.maxMessageSize, this.maxBufferSize, this.channelLifetime, this.securityTokenLifetime);
        }
    }

    public static enum Fields {
        OperationTimeout("OperationTimeout", Integer.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=6")), -1),
        UseBinaryEncoding("UseBinaryEncoding", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1),
        MaxStringLength("MaxStringLength", Integer.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=6")), -1),
        MaxByteStringLength("MaxByteStringLength", Integer.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=6")), -1),
        MaxArrayLength("MaxArrayLength", Integer.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=6")), -1),
        MaxMessageSize("MaxMessageSize", Integer.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=6")), -1),
        MaxBufferSize("MaxBufferSize", Integer.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=6")), -1),
        ChannelLifetime("ChannelLifetime", Integer.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=6")), -1),
        SecurityTokenLifetime("SecurityTokenLifetime", Integer.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=6")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

