/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ConfigurationVersionDataType;
import com.prosysopc.ua.stack.core.DataTypeSchemaHeader;
import com.prosysopc.ua.stack.core.EnumDescription;
import com.prosysopc.ua.stack.core.FieldMetaData;
import com.prosysopc.ua.stack.core.SimpleTypeDescription;
import com.prosysopc.ua.stack.core.StructureDescription;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;
import java.util.UUID;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14523")
public class DataSetMetaDataType
extends DataTypeSchemaHeader {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.DataSetMetaDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.DataSetMetaDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.DataSetMetaDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.DataSetMetaDataType;
    public static final StructureSpecification SPECIFICATION;
    private String name;
    private LocalizedText description;
    private FieldMetaData[] fields;
    private UUID dataSetClassId;
    private ConfigurationVersionDataType configurationVersion;

    public DataSetMetaDataType() {
    }

    public DataSetMetaDataType(String string, LocalizedText localizedText, FieldMetaData[] fieldMetaDataArray, UUID uUID, ConfigurationVersionDataType configurationVersionDataType) {
        this.name = string;
        this.description = localizedText;
        this.fields = fieldMetaDataArray;
        this.dataSetClassId = uUID;
        this.configurationVersion = configurationVersionDataType;
    }

    public DataSetMetaDataType(String[] stringArray, StructureDescription[] structureDescriptionArray, EnumDescription[] enumDescriptionArray, SimpleTypeDescription[] simpleTypeDescriptionArray, String string, LocalizedText localizedText, FieldMetaData[] fieldMetaDataArray, UUID uUID, ConfigurationVersionDataType configurationVersionDataType) {
        super(stringArray, structureDescriptionArray, enumDescriptionArray, simpleTypeDescriptionArray);
        this.name = string;
        this.description = localizedText;
        this.fields = fieldMetaDataArray;
        this.dataSetClassId = uUID;
        this.configurationVersion = configurationVersionDataType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    public void setDescription(LocalizedText localizedText) {
        this.description = localizedText;
    }

    public FieldMetaData[] getFields() {
        return this.fields;
    }

    public void setFields(FieldMetaData[] fieldMetaDataArray) {
        this.fields = fieldMetaDataArray;
    }

    public UUID getDataSetClassId() {
        return this.dataSetClassId;
    }

    public void setDataSetClassId(UUID uUID) {
        this.dataSetClassId = uUID;
    }

    public ConfigurationVersionDataType getConfigurationVersion() {
        return this.configurationVersion;
    }

    public void setConfigurationVersion(ConfigurationVersionDataType configurationVersionDataType) {
        this.configurationVersion = configurationVersionDataType;
    }

    @Override
    public DataSetMetaDataType clone() {
        DataSetMetaDataType dataSetMetaDataType = (DataSetMetaDataType)super.clone();
        dataSetMetaDataType.name = StructureUtils.clone(this.name);
        dataSetMetaDataType.description = StructureUtils.clone(this.description);
        dataSetMetaDataType.fields = StructureUtils.clone(this.fields);
        dataSetMetaDataType.dataSetClassId = StructureUtils.clone(this.dataSetClassId);
        dataSetMetaDataType.configurationVersion = StructureUtils.clone(this.configurationVersion);
        return dataSetMetaDataType;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DataSetMetaDataType dataSetMetaDataType = (DataSetMetaDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNamespaces(), dataSetMetaDataType.getNamespaces())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getStructureDataTypes(), dataSetMetaDataType.getStructureDataTypes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getEnumDataTypes(), dataSetMetaDataType.getEnumDataTypes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getSimpleDataTypes(), dataSetMetaDataType.getSimpleDataTypes())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getName(), dataSetMetaDataType.getName())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDescription(), dataSetMetaDataType.getDescription())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getFields(), dataSetMetaDataType.getFields())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDataSetClassId(), dataSetMetaDataType.getDataSetClassId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getConfigurationVersion(), dataSetMetaDataType.getConfigurationVersion());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getNamespaces(), this.getStructureDataTypes(), this.getEnumDataTypes(), this.getSimpleDataTypes(), this.getName(), this.getDescription(), this.getFields(), this.getDataSetClassId(), this.getConfigurationVersion());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Namespaces.getSpecification().equals(fieldSpecification)) {
            return this.getNamespaces();
        }
        if (Fields.StructureDataTypes.getSpecification().equals(fieldSpecification)) {
            return this.getStructureDataTypes();
        }
        if (Fields.EnumDataTypes.getSpecification().equals(fieldSpecification)) {
            return this.getEnumDataTypes();
        }
        if (Fields.SimpleDataTypes.getSpecification().equals(fieldSpecification)) {
            return this.getSimpleDataTypes();
        }
        if (Fields.Name.getSpecification().equals(fieldSpecification)) {
            return this.getName();
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            return this.getDescription();
        }
        if (Fields.Fields.getSpecification().equals(fieldSpecification)) {
            return this.getFields();
        }
        if (Fields.DataSetClassId.getSpecification().equals(fieldSpecification)) {
            return this.getDataSetClassId();
        }
        if (Fields.ConfigurationVersion.getSpecification().equals(fieldSpecification)) {
            return this.getConfigurationVersion();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Namespaces.getSpecification().equals(fieldSpecification)) {
            this.setNamespaces((String[])object);
            return;
        }
        if (Fields.StructureDataTypes.getSpecification().equals(fieldSpecification)) {
            this.setStructureDataTypes((StructureDescription[])object);
            return;
        }
        if (Fields.EnumDataTypes.getSpecification().equals(fieldSpecification)) {
            this.setEnumDataTypes((EnumDescription[])object);
            return;
        }
        if (Fields.SimpleDataTypes.getSpecification().equals(fieldSpecification)) {
            this.setSimpleDataTypes((SimpleTypeDescription[])object);
            return;
        }
        if (Fields.Name.getSpecification().equals(fieldSpecification)) {
            this.setName((String)object);
            return;
        }
        if (Fields.Description.getSpecification().equals(fieldSpecification)) {
            this.setDescription((LocalizedText)object);
            return;
        }
        if (Fields.Fields.getSpecification().equals(fieldSpecification)) {
            this.setFields((FieldMetaData[])object);
            return;
        }
        if (Fields.DataSetClassId.getSpecification().equals(fieldSpecification)) {
            this.setDataSetClassId((UUID)object);
            return;
        }
        if (Fields.ConfigurationVersion.getSpecification().equals(fieldSpecification)) {
            this.setConfigurationVersion((ConfigurationVersionDataType)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = DataSetMetaDataType.builder();
        builder.setNamespaces(this.getNamespaces());
        builder.setStructureDataTypes(this.getStructureDataTypes());
        builder.setEnumDataTypes(this.getEnumDataTypes());
        builder.setSimpleDataTypes(this.getSimpleDataTypes());
        builder.setName(this.getName());
        builder.setDescription(this.getDescription());
        builder.setFields(this.getFields());
        builder.setDataSetClassId(this.getDataSetClassId());
        builder.setConfigurationVersion(this.getConfigurationVersion());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Namespaces.getSpecification());
        builder.addField(Fields.StructureDataTypes.getSpecification());
        builder.addField(Fields.EnumDataTypes.getSpecification());
        builder.addField(Fields.SimpleDataTypes.getSpecification());
        builder.addField(Fields.Name.getSpecification());
        builder.addField(Fields.Description.getSpecification());
        builder.addField(Fields.Fields.getSpecification());
        builder.addField(Fields.DataSetClassId.getSpecification());
        builder.addField(Fields.ConfigurationVersion.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("DataSetMetaDataType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.DataSetMetaDataTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return DataSetMetaDataType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends DataTypeSchemaHeader.Builder {
        private String[] namespaces;
        private StructureDescription[] structureDataTypes;
        private EnumDescription[] enumDataTypes;
        private SimpleTypeDescription[] simpleDataTypes;
        private String name;
        private LocalizedText description;
        private FieldMetaData[] fields;
        private UUID dataSetClassId;
        private ConfigurationVersionDataType configurationVersion;

        protected Builder() {
        }

        @Override
        public Builder setNamespaces(String[] stringArray) {
            this.namespaces = stringArray;
            return this;
        }

        @Override
        public Builder setStructureDataTypes(StructureDescription[] structureDescriptionArray) {
            this.structureDataTypes = structureDescriptionArray;
            return this;
        }

        @Override
        public Builder setEnumDataTypes(EnumDescription[] enumDescriptionArray) {
            this.enumDataTypes = enumDescriptionArray;
            return this;
        }

        @Override
        public Builder setSimpleDataTypes(SimpleTypeDescription[] simpleTypeDescriptionArray) {
            this.simpleDataTypes = simpleTypeDescriptionArray;
            return this;
        }

        public Builder setName(String string) {
            this.name = string;
            return this;
        }

        public Builder setDescription(LocalizedText localizedText) {
            this.description = localizedText;
            return this;
        }

        public Builder setFields(FieldMetaData[] fieldMetaDataArray) {
            this.fields = fieldMetaDataArray;
            return this;
        }

        public Builder setDataSetClassId(UUID uUID) {
            this.dataSetClassId = uUID;
            return this;
        }

        public Builder setConfigurationVersion(ConfigurationVersionDataType configurationVersionDataType) {
            this.configurationVersion = configurationVersionDataType;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Namespaces.getSpecification().equals(fieldSpecification)) {
                this.setNamespaces((String[])object);
                return this;
            }
            if (Fields.StructureDataTypes.getSpecification().equals(fieldSpecification)) {
                this.setStructureDataTypes((StructureDescription[])object);
                return this;
            }
            if (Fields.EnumDataTypes.getSpecification().equals(fieldSpecification)) {
                this.setEnumDataTypes((EnumDescription[])object);
                return this;
            }
            if (Fields.SimpleDataTypes.getSpecification().equals(fieldSpecification)) {
                this.setSimpleDataTypes((SimpleTypeDescription[])object);
                return this;
            }
            if (Fields.Name.getSpecification().equals(fieldSpecification)) {
                this.setName((String)object);
                return this;
            }
            if (Fields.Description.getSpecification().equals(fieldSpecification)) {
                this.setDescription((LocalizedText)object);
                return this;
            }
            if (Fields.Fields.getSpecification().equals(fieldSpecification)) {
                this.setFields((FieldMetaData[])object);
                return this;
            }
            if (Fields.DataSetClassId.getSpecification().equals(fieldSpecification)) {
                this.setDataSetClassId((UUID)object);
                return this;
            }
            if (Fields.ConfigurationVersion.getSpecification().equals(fieldSpecification)) {
                this.setConfigurationVersion((ConfigurationVersionDataType)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public DataSetMetaDataType build() {
            return new DataSetMetaDataType(this.namespaces, this.structureDataTypes, this.enumDataTypes, this.simpleDataTypes, this.name, this.description, this.fields, this.dataSetClassId, this.configurationVersion);
        }
    }

    public static enum Fields {
        Namespaces("Namespaces", String[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), 1),
        StructureDataTypes("StructureDataTypes", StructureDescription[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15487")), 1),
        EnumDataTypes("EnumDataTypes", EnumDescription[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15488")), 1),
        SimpleDataTypes("SimpleDataTypes", SimpleTypeDescription[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15005")), 1),
        Name("Name", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        Description("Description", LocalizedText.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=21")), -1),
        Fields("Fields", FieldMetaData[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=14524")), 1),
        DataSetClassId("DataSetClassId", UUID.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=14")), -1),
        ConfigurationVersion("ConfigurationVersion", ConfigurationVersionDataType.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=14593")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

