/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.DataChangeTrigger;
import com.prosysopc.ua.stack.core.MonitoringFilter;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=722")
public class DataChangeFilter
extends MonitoringFilter {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.DataChangeFilter_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.DataChangeFilter_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.DataChangeFilter_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.DataChangeFilter;
    public static final StructureSpecification SPECIFICATION;
    private DataChangeTrigger trigger;
    private UnsignedInteger deadbandType;
    private Double deadbandValue;

    public DataChangeFilter() {
    }

    public DataChangeFilter(DataChangeTrigger dataChangeTrigger, UnsignedInteger unsignedInteger, Double d2) {
        this.trigger = dataChangeTrigger;
        this.deadbandType = unsignedInteger;
        this.deadbandValue = d2;
    }

    public DataChangeTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(DataChangeTrigger dataChangeTrigger) {
        this.trigger = dataChangeTrigger;
    }

    public UnsignedInteger getDeadbandType() {
        return this.deadbandType;
    }

    public void setDeadbandType(UnsignedInteger unsignedInteger) {
        this.deadbandType = unsignedInteger;
    }

    public Double getDeadbandValue() {
        return this.deadbandValue;
    }

    public void setDeadbandValue(Double d2) {
        this.deadbandValue = d2;
    }

    @Override
    public DataChangeFilter clone() {
        DataChangeFilter dataChangeFilter = (DataChangeFilter)super.clone();
        dataChangeFilter.trigger = StructureUtils.clone(this.trigger);
        dataChangeFilter.deadbandType = StructureUtils.clone(this.deadbandType);
        dataChangeFilter.deadbandValue = StructureUtils.clone(this.deadbandValue);
        return dataChangeFilter;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DataChangeFilter dataChangeFilter = (DataChangeFilter)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getTrigger(), dataChangeFilter.getTrigger())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getDeadbandType(), dataChangeFilter.getDeadbandType())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDeadbandValue(), dataChangeFilter.getDeadbandValue());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getTrigger(), this.getDeadbandType(), this.getDeadbandValue());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Trigger.getSpecification().equals(fieldSpecification)) {
            return this.getTrigger();
        }
        if (Fields.DeadbandType.getSpecification().equals(fieldSpecification)) {
            return this.getDeadbandType();
        }
        if (Fields.DeadbandValue.getSpecification().equals(fieldSpecification)) {
            return this.getDeadbandValue();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Trigger.getSpecification().equals(fieldSpecification)) {
            this.setTrigger((DataChangeTrigger)object);
            return;
        }
        if (Fields.DeadbandType.getSpecification().equals(fieldSpecification)) {
            this.setDeadbandType((UnsignedInteger)object);
            return;
        }
        if (Fields.DeadbandValue.getSpecification().equals(fieldSpecification)) {
            this.setDeadbandValue((Double)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = DataChangeFilter.builder();
        builder.setTrigger(this.getTrigger());
        builder.setDeadbandType(this.getDeadbandType());
        builder.setDeadbandValue(this.getDeadbandValue());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Trigger.getSpecification());
        builder.addField(Fields.DeadbandType.getSpecification());
        builder.addField(Fields.DeadbandValue.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("DataChangeFilter");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.DataChangeFilterSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return DataChangeFilter.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends MonitoringFilter.Builder {
        private DataChangeTrigger trigger;
        private UnsignedInteger deadbandType;
        private Double deadbandValue;

        protected Builder() {
        }

        public Builder setTrigger(DataChangeTrigger dataChangeTrigger) {
            this.trigger = dataChangeTrigger;
            return this;
        }

        public Builder setDeadbandType(UnsignedInteger unsignedInteger) {
            this.deadbandType = unsignedInteger;
            return this;
        }

        public Builder setDeadbandValue(Double d2) {
            this.deadbandValue = d2;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Trigger.getSpecification().equals(fieldSpecification)) {
                this.setTrigger((DataChangeTrigger)object);
                return this;
            }
            if (Fields.DeadbandType.getSpecification().equals(fieldSpecification)) {
                this.setDeadbandType((UnsignedInteger)object);
                return this;
            }
            if (Fields.DeadbandValue.getSpecification().equals(fieldSpecification)) {
                this.setDeadbandValue((Double)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public DataChangeFilter build() {
            return new DataChangeFilter(this.trigger, this.deadbandType, this.deadbandValue);
        }
    }

    public static enum Fields {
        Trigger("Trigger", DataChangeTrigger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=717")), -1),
        DeadbandType("DeadbandType", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1),
        DeadbandValue("DeadbandValue", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

