/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ContentFilterElementResult;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=607")
public class ContentFilterResult
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ContentFilterResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ContentFilterResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ContentFilterResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ContentFilterResult;
    public static final StructureSpecification SPECIFICATION;
    private ContentFilterElementResult[] elementResults;
    private DiagnosticInfo[] elementDiagnosticInfos;

    public ContentFilterResult() {
    }

    public ContentFilterResult(ContentFilterElementResult[] contentFilterElementResultArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.elementResults = contentFilterElementResultArray;
        this.elementDiagnosticInfos = diagnosticInfoArray;
    }

    public ContentFilterElementResult[] getElementResults() {
        return this.elementResults;
    }

    public void setElementResults(ContentFilterElementResult[] contentFilterElementResultArray) {
        this.elementResults = contentFilterElementResultArray;
    }

    public DiagnosticInfo[] getElementDiagnosticInfos() {
        return this.elementDiagnosticInfos;
    }

    public void setElementDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.elementDiagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public ContentFilterResult clone() {
        ContentFilterResult contentFilterResult = (ContentFilterResult)super.clone();
        contentFilterResult.elementResults = StructureUtils.clone(this.elementResults);
        contentFilterResult.elementDiagnosticInfos = StructureUtils.clone(this.elementDiagnosticInfos);
        return contentFilterResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ContentFilterResult contentFilterResult = (ContentFilterResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getElementResults(), contentFilterResult.getElementResults())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getElementDiagnosticInfos(), contentFilterResult.getElementDiagnosticInfos());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getElementResults(), this.getElementDiagnosticInfos());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ElementResults.getSpecification().equals(fieldSpecification)) {
            return this.getElementResults();
        }
        if (Fields.ElementDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            return this.getElementDiagnosticInfos();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ElementResults.getSpecification().equals(fieldSpecification)) {
            this.setElementResults((ContentFilterElementResult[])object);
            return;
        }
        if (Fields.ElementDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            this.setElementDiagnosticInfos((DiagnosticInfo[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ContentFilterResult.builder();
        builder.setElementResults(this.getElementResults());
        builder.setElementDiagnosticInfos(this.getElementDiagnosticInfos());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ElementResults.getSpecification());
        builder.addField(Fields.ElementDiagnosticInfos.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ContentFilterResult");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ContentFilterResultSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ContentFilterResult.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ContentFilterElementResult[] elementResults;
        private DiagnosticInfo[] elementDiagnosticInfos;

        protected Builder() {
        }

        public Builder setElementResults(ContentFilterElementResult[] contentFilterElementResultArray) {
            this.elementResults = contentFilterElementResultArray;
            return this;
        }

        public Builder setElementDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
            this.elementDiagnosticInfos = diagnosticInfoArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ElementResults.getSpecification().equals(fieldSpecification)) {
                this.setElementResults((ContentFilterElementResult[])object);
                return this;
            }
            if (Fields.ElementDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
                this.setElementDiagnosticInfos((DiagnosticInfo[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ContentFilterResult build() {
            return new ContentFilterResult(this.elementResults, this.elementDiagnosticInfos);
        }
    }

    public static enum Fields {
        ElementResults("ElementResults", ContentFilterElementResult[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=604")), 1),
        ElementDiagnosticInfos("ElementDiagnosticInfos", DiagnosticInfo[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=25")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

