/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=604")
public class ContentFilterElementResult
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ContentFilterElementResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ContentFilterElementResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ContentFilterElementResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ContentFilterElementResult;
    public static final StructureSpecification SPECIFICATION;
    private StatusCode statusCode;
    private StatusCode[] operandStatusCodes;
    private DiagnosticInfo[] operandDiagnosticInfos;

    public ContentFilterElementResult() {
    }

    public ContentFilterElementResult(StatusCode statusCode, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.statusCode = statusCode;
        this.operandStatusCodes = statusCodeArray;
        this.operandDiagnosticInfos = diagnosticInfoArray;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public StatusCode[] getOperandStatusCodes() {
        return this.operandStatusCodes;
    }

    public void setOperandStatusCodes(StatusCode[] statusCodeArray) {
        this.operandStatusCodes = statusCodeArray;
    }

    public DiagnosticInfo[] getOperandDiagnosticInfos() {
        return this.operandDiagnosticInfos;
    }

    public void setOperandDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.operandDiagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public ContentFilterElementResult clone() {
        ContentFilterElementResult contentFilterElementResult = (ContentFilterElementResult)super.clone();
        contentFilterElementResult.statusCode = StructureUtils.clone(this.statusCode);
        contentFilterElementResult.operandStatusCodes = StructureUtils.clone(this.operandStatusCodes);
        contentFilterElementResult.operandDiagnosticInfos = StructureUtils.clone(this.operandDiagnosticInfos);
        return contentFilterElementResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ContentFilterElementResult contentFilterElementResult = (ContentFilterElementResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStatusCode(), contentFilterElementResult.getStatusCode())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getOperandStatusCodes(), contentFilterElementResult.getOperandStatusCodes())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getOperandDiagnosticInfos(), contentFilterElementResult.getOperandDiagnosticInfos());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStatusCode(), this.getOperandStatusCodes(), this.getOperandDiagnosticInfos());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            return this.getStatusCode();
        }
        if (Fields.OperandStatusCodes.getSpecification().equals(fieldSpecification)) {
            return this.getOperandStatusCodes();
        }
        if (Fields.OperandDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            return this.getOperandDiagnosticInfos();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            this.setStatusCode((StatusCode)object);
            return;
        }
        if (Fields.OperandStatusCodes.getSpecification().equals(fieldSpecification)) {
            this.setOperandStatusCodes((StatusCode[])object);
            return;
        }
        if (Fields.OperandDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            this.setOperandDiagnosticInfos((DiagnosticInfo[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ContentFilterElementResult.builder();
        builder.setStatusCode(this.getStatusCode());
        builder.setOperandStatusCodes(this.getOperandStatusCodes());
        builder.setOperandDiagnosticInfos(this.getOperandDiagnosticInfos());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.StatusCode.getSpecification());
        builder.addField(Fields.OperandStatusCodes.getSpecification());
        builder.addField(Fields.OperandDiagnosticInfos.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ContentFilterElementResult");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ContentFilterElementResultSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ContentFilterElementResult.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private StatusCode statusCode;
        private StatusCode[] operandStatusCodes;
        private DiagnosticInfo[] operandDiagnosticInfos;

        protected Builder() {
        }

        public Builder setStatusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setOperandStatusCodes(StatusCode[] statusCodeArray) {
            this.operandStatusCodes = statusCodeArray;
            return this;
        }

        public Builder setOperandDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
            this.operandDiagnosticInfos = diagnosticInfoArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
                this.setStatusCode((StatusCode)object);
                return this;
            }
            if (Fields.OperandStatusCodes.getSpecification().equals(fieldSpecification)) {
                this.setOperandStatusCodes((StatusCode[])object);
                return this;
            }
            if (Fields.OperandDiagnosticInfos.getSpecification().equals(fieldSpecification)) {
                this.setOperandDiagnosticInfos((DiagnosticInfo[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ContentFilterElementResult build() {
            return new ContentFilterElementResult(this.statusCode, this.operandStatusCodes, this.operandDiagnosticInfos);
        }
    }

    public static enum Fields {
        StatusCode("StatusCode", StatusCode.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), -1),
        OperandStatusCodes("OperandStatusCodes", StatusCode[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), 1),
        OperandDiagnosticInfos("OperandDiagnosticInfos", DiagnosticInfo[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=25")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

