/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.FilterOperator;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=583")
public class ContentFilterElement
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ContentFilterElement_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ContentFilterElement_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ContentFilterElement_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ContentFilterElement;
    public static final StructureSpecification SPECIFICATION;
    private FilterOperator filterOperator;
    private ExtensionObject[] filterOperands;

    public ContentFilterElement() {
    }

    public ContentFilterElement(FilterOperator filterOperator, ExtensionObject[] extensionObjectArray) {
        this.filterOperator = filterOperator;
        this.filterOperands = extensionObjectArray;
    }

    public FilterOperator getFilterOperator() {
        return this.filterOperator;
    }

    public void setFilterOperator(FilterOperator filterOperator) {
        this.filterOperator = filterOperator;
    }

    public ExtensionObject[] getFilterOperands() {
        return this.filterOperands;
    }

    public void setFilterOperands(ExtensionObject[] extensionObjectArray) {
        this.filterOperands = extensionObjectArray;
    }

    @Override
    public ContentFilterElement clone() {
        ContentFilterElement contentFilterElement = (ContentFilterElement)super.clone();
        contentFilterElement.filterOperator = StructureUtils.clone(this.filterOperator);
        contentFilterElement.filterOperands = StructureUtils.clone(this.filterOperands);
        return contentFilterElement;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ContentFilterElement contentFilterElement = (ContentFilterElement)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getFilterOperator(), contentFilterElement.getFilterOperator())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getFilterOperands(), contentFilterElement.getFilterOperands());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getFilterOperator(), this.getFilterOperands());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.FilterOperator.getSpecification().equals(fieldSpecification)) {
            return this.getFilterOperator();
        }
        if (Fields.FilterOperands.getSpecification().equals(fieldSpecification)) {
            return this.getFilterOperands();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.FilterOperator.getSpecification().equals(fieldSpecification)) {
            this.setFilterOperator((FilterOperator)object);
            return;
        }
        if (Fields.FilterOperands.getSpecification().equals(fieldSpecification)) {
            this.setFilterOperands((ExtensionObject[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ContentFilterElement.builder();
        builder.setFilterOperator(this.getFilterOperator());
        builder.setFilterOperands(this.getFilterOperands());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.FilterOperator.getSpecification());
        builder.addField(Fields.FilterOperands.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ContentFilterElement");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ContentFilterElementSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ContentFilterElement.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private FilterOperator filterOperator;
        private ExtensionObject[] filterOperands;

        protected Builder() {
        }

        public Builder setFilterOperator(FilterOperator filterOperator) {
            this.filterOperator = filterOperator;
            return this;
        }

        public Builder setFilterOperands(ExtensionObject[] extensionObjectArray) {
            this.filterOperands = extensionObjectArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.FilterOperator.getSpecification().equals(fieldSpecification)) {
                this.setFilterOperator((FilterOperator)object);
                return this;
            }
            if (Fields.FilterOperands.getSpecification().equals(fieldSpecification)) {
                this.setFilterOperands((ExtensionObject[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ContentFilterElement build() {
            return new ContentFilterElement(this.filterOperator, this.filterOperands);
        }
    }

    public static enum Fields {
        FilterOperator("FilterOperator", FilterOperator.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=576")), -1),
        FilterOperands("FilterOperands", Structure[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=22")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

