/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14593")
public class ConfigurationVersionDataType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ConfigurationVersionDataType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ConfigurationVersionDataType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ConfigurationVersionDataType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ConfigurationVersionDataType;
    public static final StructureSpecification SPECIFICATION;
    private UnsignedInteger majorVersion;
    private UnsignedInteger minorVersion;

    public ConfigurationVersionDataType() {
    }

    public ConfigurationVersionDataType(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) {
        this.majorVersion = unsignedInteger;
        this.minorVersion = unsignedInteger2;
    }

    public UnsignedInteger getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(UnsignedInteger unsignedInteger) {
        this.majorVersion = unsignedInteger;
    }

    public UnsignedInteger getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(UnsignedInteger unsignedInteger) {
        this.minorVersion = unsignedInteger;
    }

    @Override
    public ConfigurationVersionDataType clone() {
        ConfigurationVersionDataType configurationVersionDataType = (ConfigurationVersionDataType)super.clone();
        configurationVersionDataType.majorVersion = StructureUtils.clone(this.majorVersion);
        configurationVersionDataType.minorVersion = StructureUtils.clone(this.minorVersion);
        return configurationVersionDataType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ConfigurationVersionDataType configurationVersionDataType = (ConfigurationVersionDataType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getMajorVersion(), configurationVersionDataType.getMajorVersion())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getMinorVersion(), configurationVersionDataType.getMinorVersion());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getMajorVersion(), this.getMinorVersion());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.MajorVersion.getSpecification().equals(fieldSpecification)) {
            return this.getMajorVersion();
        }
        if (Fields.MinorVersion.getSpecification().equals(fieldSpecification)) {
            return this.getMinorVersion();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.MajorVersion.getSpecification().equals(fieldSpecification)) {
            this.setMajorVersion((UnsignedInteger)object);
            return;
        }
        if (Fields.MinorVersion.getSpecification().equals(fieldSpecification)) {
            this.setMinorVersion((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ConfigurationVersionDataType.builder();
        builder.setMajorVersion(this.getMajorVersion());
        builder.setMinorVersion(this.getMinorVersion());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.MajorVersion.getSpecification());
        builder.addField(Fields.MinorVersion.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ConfigurationVersionDataType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ConfigurationVersionDataTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ConfigurationVersionDataType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private UnsignedInteger majorVersion;
        private UnsignedInteger minorVersion;

        protected Builder() {
        }

        public Builder setMajorVersion(UnsignedInteger unsignedInteger) {
            this.majorVersion = unsignedInteger;
            return this;
        }

        public Builder setMinorVersion(UnsignedInteger unsignedInteger) {
            this.minorVersion = unsignedInteger;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.MajorVersion.getSpecification().equals(fieldSpecification)) {
                this.setMajorVersion((UnsignedInteger)object);
                return this;
            }
            if (Fields.MinorVersion.getSpecification().equals(fieldSpecification)) {
                this.setMinorVersion((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ConfigurationVersionDataType build() {
            return new ConfigurationVersionDataType(this.majorVersion, this.minorVersion);
        }
    }

    public static enum Fields {
        MajorVersion("MajorVersion", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=20998")), -1),
        MinorVersion("MinorVersion", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=20998")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

