/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12171")
public class ComplexNumberType
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.ComplexNumberType_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.ComplexNumberType_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.ComplexNumberType_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.ComplexNumberType;
    public static final StructureSpecification SPECIFICATION;
    private Float real;
    private Float imaginary;

    public ComplexNumberType() {
    }

    public ComplexNumberType(Float f2, Float f3) {
        this.real = f2;
        this.imaginary = f3;
    }

    public Float getReal() {
        return this.real;
    }

    public void setReal(Float f2) {
        this.real = f2;
    }

    public Float getImaginary() {
        return this.imaginary;
    }

    public void setImaginary(Float f2) {
        this.imaginary = f2;
    }

    @Override
    public ComplexNumberType clone() {
        ComplexNumberType complexNumberType = (ComplexNumberType)super.clone();
        complexNumberType.real = StructureUtils.clone(this.real);
        complexNumberType.imaginary = StructureUtils.clone(this.imaginary);
        return complexNumberType;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ComplexNumberType complexNumberType = (ComplexNumberType)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getReal(), complexNumberType.getReal())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getImaginary(), complexNumberType.getImaginary());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getReal(), this.getImaginary());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.Real.getSpecification().equals(fieldSpecification)) {
            return this.getReal();
        }
        if (Fields.Imaginary.getSpecification().equals(fieldSpecification)) {
            return this.getImaginary();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.Real.getSpecification().equals(fieldSpecification)) {
            this.setReal((Float)object);
            return;
        }
        if (Fields.Imaginary.getSpecification().equals(fieldSpecification)) {
            this.setImaginary((Float)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ComplexNumberType.builder();
        builder.setReal(this.getReal());
        builder.setImaginary(this.getImaginary());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.Real.getSpecification());
        builder.addField(Fields.Imaginary.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("ComplexNumberType");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.ComplexNumberTypeSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return ComplexNumberType.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Float real;
        private Float imaginary;

        protected Builder() {
        }

        public Builder setReal(Float f2) {
            this.real = f2;
            return this;
        }

        public Builder setImaginary(Float f2) {
            this.imaginary = f2;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.Real.getSpecification().equals(fieldSpecification)) {
                this.setReal((Float)object);
                return this;
            }
            if (Fields.Imaginary.getSpecification().equals(fieldSpecification)) {
                this.setImaginary((Float)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public ComplexNumberType build() {
            return new ComplexNumberType(this.real, this.imaginary);
        }
    }

    public static enum Fields {
        Real("Real", Float.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=10")), -1),
        Imaginary("Imaginary", Float.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=10")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

