/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=480")
public class CancelResponse
extends AbstractStructure
implements ServiceResponse {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.CancelResponse_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.CancelResponse_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.CancelResponse_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.CancelResponse;
    public static final StructureSpecification SPECIFICATION;
    private ResponseHeader responseHeader;
    private UnsignedInteger cancelCount;

    public CancelResponse() {
    }

    public CancelResponse(ResponseHeader responseHeader, UnsignedInteger unsignedInteger) {
        this.responseHeader = responseHeader;
        this.cancelCount = unsignedInteger;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.responseHeader = responseHeader;
    }

    public UnsignedInteger getCancelCount() {
        return this.cancelCount;
    }

    public void setCancelCount(UnsignedInteger unsignedInteger) {
        this.cancelCount = unsignedInteger;
    }

    @Override
    public CancelResponse clone() {
        CancelResponse cancelResponse = (CancelResponse)super.clone();
        cancelResponse.responseHeader = StructureUtils.clone(this.responseHeader);
        cancelResponse.cancelCount = StructureUtils.clone(this.cancelCount);
        return cancelResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CancelResponse cancelResponse = (CancelResponse)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getResponseHeader(), cancelResponse.getResponseHeader())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getCancelCount(), cancelResponse.getCancelCount());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getResponseHeader(), this.getCancelCount());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            return this.getResponseHeader();
        }
        if (Fields.CancelCount.getSpecification().equals(fieldSpecification)) {
            return this.getCancelCount();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            this.setResponseHeader((ResponseHeader)object);
            return;
        }
        if (Fields.CancelCount.getSpecification().equals(fieldSpecification)) {
            this.setCancelCount((UnsignedInteger)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = CancelResponse.builder();
        builder.setResponseHeader(this.getResponseHeader());
        builder.setCancelCount(this.getCancelCount());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ResponseHeader.getSpecification());
        builder.addField(Fields.CancelCount.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("CancelResponse");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.CancelResponseSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return CancelResponse.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ResponseHeader responseHeader;
        private UnsignedInteger cancelCount;

        protected Builder() {
        }

        public Builder setResponseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return this;
        }

        public Builder setCancelCount(UnsignedInteger unsignedInteger) {
            this.cancelCount = unsignedInteger;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
                this.setResponseHeader((ResponseHeader)object);
                return this;
            }
            if (Fields.CancelCount.getSpecification().equals(fieldSpecification)) {
                this.setCancelCount((UnsignedInteger)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public CancelResponse build() {
            return new CancelResponse(this.responseHeader, this.cancelCount);
        }
    }

    public static enum Fields {
        ResponseHeader("ResponseHeader", ResponseHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=392")), -1),
        CancelCount("CancelCount", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=7")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

