/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.BrowseDescription;
import com.prosysopc.ua.stack.core.BrowseResponse;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.ViewDescription;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=525")
public class BrowseRequest
extends AbstractStructure
implements ServiceRequest<BrowseResponse> {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.BrowseRequest_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.BrowseRequest_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.BrowseRequest_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.BrowseRequest;
    public static final StructureSpecification SPECIFICATION;
    private RequestHeader requestHeader;
    private ViewDescription view;
    private UnsignedInteger requestedMaxReferencesPerNode;
    private BrowseDescription[] nodesToBrowse;

    public BrowseRequest() {
    }

    public BrowseRequest(RequestHeader requestHeader, ViewDescription viewDescription, UnsignedInteger unsignedInteger, BrowseDescription[] browseDescriptionArray) {
        this.requestHeader = requestHeader;
        this.view = viewDescription;
        this.requestedMaxReferencesPerNode = unsignedInteger;
        this.nodesToBrowse = browseDescriptionArray;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public void setRequestHeader(RequestHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public ViewDescription getView() {
        return this.view;
    }

    public void setView(ViewDescription viewDescription) {
        this.view = viewDescription;
    }

    public UnsignedInteger getRequestedMaxReferencesPerNode() {
        return this.requestedMaxReferencesPerNode;
    }

    public void setRequestedMaxReferencesPerNode(UnsignedInteger unsignedInteger) {
        this.requestedMaxReferencesPerNode = unsignedInteger;
    }

    public BrowseDescription[] getNodesToBrowse() {
        return this.nodesToBrowse;
    }

    public void setNodesToBrowse(BrowseDescription[] browseDescriptionArray) {
        this.nodesToBrowse = browseDescriptionArray;
    }

    @Override
    public BrowseRequest clone() {
        BrowseRequest browseRequest = (BrowseRequest)super.clone();
        browseRequest.requestHeader = StructureUtils.clone(this.requestHeader);
        browseRequest.view = StructureUtils.clone(this.view);
        browseRequest.requestedMaxReferencesPerNode = StructureUtils.clone(this.requestedMaxReferencesPerNode);
        browseRequest.nodesToBrowse = StructureUtils.clone(this.nodesToBrowse);
        return browseRequest;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowseRequest browseRequest = (BrowseRequest)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestHeader(), browseRequest.getRequestHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getView(), browseRequest.getView())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getRequestedMaxReferencesPerNode(), browseRequest.getRequestedMaxReferencesPerNode())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getNodesToBrowse(), browseRequest.getNodesToBrowse());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getRequestHeader(), this.getView(), this.getRequestedMaxReferencesPerNode(), this.getNodesToBrowse());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            return this.getRequestHeader();
        }
        if (Fields.View.getSpecification().equals(fieldSpecification)) {
            return this.getView();
        }
        if (Fields.RequestedMaxReferencesPerNode.getSpecification().equals(fieldSpecification)) {
            return this.getRequestedMaxReferencesPerNode();
        }
        if (Fields.NodesToBrowse.getSpecification().equals(fieldSpecification)) {
            return this.getNodesToBrowse();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
            this.setRequestHeader((RequestHeader)object);
            return;
        }
        if (Fields.View.getSpecification().equals(fieldSpecification)) {
            this.setView((ViewDescription)object);
            return;
        }
        if (Fields.RequestedMaxReferencesPerNode.getSpecification().equals(fieldSpecification)) {
            this.setRequestedMaxReferencesPerNode((UnsignedInteger)object);
            return;
        }
        if (Fields.NodesToBrowse.getSpecification().equals(fieldSpecification)) {
            this.setNodesToBrowse((BrowseDescription[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = BrowseRequest.builder();
        builder.setRequestHeader(this.getRequestHeader());
        builder.setView(this.getView());
        builder.setRequestedMaxReferencesPerNode(this.getRequestedMaxReferencesPerNode());
        builder.setNodesToBrowse(this.getNodesToBrowse());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RequestHeader.getSpecification());
        builder.addField(Fields.View.getSpecification());
        builder.addField(Fields.RequestedMaxReferencesPerNode.getSpecification());
        builder.addField(Fields.NodesToBrowse.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("BrowseRequest");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.BrowseRequestSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return BrowseRequest.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private RequestHeader requestHeader;
        private ViewDescription view;
        private UnsignedInteger requestedMaxReferencesPerNode;
        private BrowseDescription[] nodesToBrowse;

        protected Builder() {
        }

        public Builder setRequestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return this;
        }

        public Builder setView(ViewDescription viewDescription) {
            this.view = viewDescription;
            return this;
        }

        public Builder setRequestedMaxReferencesPerNode(UnsignedInteger unsignedInteger) {
            this.requestedMaxReferencesPerNode = unsignedInteger;
            return this;
        }

        public Builder setNodesToBrowse(BrowseDescription[] browseDescriptionArray) {
            this.nodesToBrowse = browseDescriptionArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RequestHeader.getSpecification().equals(fieldSpecification)) {
                this.setRequestHeader((RequestHeader)object);
                return this;
            }
            if (Fields.View.getSpecification().equals(fieldSpecification)) {
                this.setView((ViewDescription)object);
                return this;
            }
            if (Fields.RequestedMaxReferencesPerNode.getSpecification().equals(fieldSpecification)) {
                this.setRequestedMaxReferencesPerNode((UnsignedInteger)object);
                return this;
            }
            if (Fields.NodesToBrowse.getSpecification().equals(fieldSpecification)) {
                this.setNodesToBrowse((BrowseDescription[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public BrowseRequest build() {
            return new BrowseRequest(this.requestHeader, this.view, this.requestedMaxReferencesPerNode, this.nodesToBrowse);
        }
    }

    public static enum Fields {
        RequestHeader("RequestHeader", RequestHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=389")), -1),
        View("View", ViewDescription.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=511")), -1),
        RequestedMaxReferencesPerNode("RequestedMaxReferencesPerNode", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=289")), -1),
        NodesToBrowse("NodesToBrowse", BrowseDescription[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=514")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

