/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.BrowsePathTarget;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=549")
public class BrowsePathResult
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.BrowsePathResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.BrowsePathResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.BrowsePathResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.BrowsePathResult;
    public static final StructureSpecification SPECIFICATION;
    private StatusCode statusCode;
    private BrowsePathTarget[] targets;

    public BrowsePathResult() {
    }

    public BrowsePathResult(StatusCode statusCode, BrowsePathTarget[] browsePathTargetArray) {
        this.statusCode = statusCode;
        this.targets = browsePathTargetArray;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public BrowsePathTarget[] getTargets() {
        return this.targets;
    }

    public void setTargets(BrowsePathTarget[] browsePathTargetArray) {
        this.targets = browsePathTargetArray;
    }

    @Override
    public BrowsePathResult clone() {
        BrowsePathResult browsePathResult = (BrowsePathResult)super.clone();
        browsePathResult.statusCode = StructureUtils.clone(this.statusCode);
        browsePathResult.targets = StructureUtils.clone(this.targets);
        return browsePathResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowsePathResult browsePathResult = (BrowsePathResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStatusCode(), browsePathResult.getStatusCode())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getTargets(), browsePathResult.getTargets());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStatusCode(), this.getTargets());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            return this.getStatusCode();
        }
        if (Fields.Targets.getSpecification().equals(fieldSpecification)) {
            return this.getTargets();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
            this.setStatusCode((StatusCode)object);
            return;
        }
        if (Fields.Targets.getSpecification().equals(fieldSpecification)) {
            this.setTargets((BrowsePathTarget[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = BrowsePathResult.builder();
        builder.setStatusCode(this.getStatusCode());
        builder.setTargets(this.getTargets());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.StatusCode.getSpecification());
        builder.addField(Fields.Targets.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("BrowsePathResult");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.BrowsePathResultSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return BrowsePathResult.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private StatusCode statusCode;
        private BrowsePathTarget[] targets;

        protected Builder() {
        }

        public Builder setStatusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setTargets(BrowsePathTarget[] browsePathTargetArray) {
            this.targets = browsePathTargetArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StatusCode.getSpecification().equals(fieldSpecification)) {
                this.setStatusCode((StatusCode)object);
                return this;
            }
            if (Fields.Targets.getSpecification().equals(fieldSpecification)) {
                this.setTargets((BrowsePathTarget[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public BrowsePathResult build() {
            return new BrowsePathResult(this.statusCode, this.targets);
        }
    }

    public static enum Fields {
        StatusCode("StatusCode", StatusCode.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=19")), -1),
        Targets("Targets", BrowsePathTarget[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=546")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

