/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=543")
public class BrowsePath
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.BrowsePath_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.BrowsePath_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.BrowsePath_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.BrowsePath;
    public static final StructureSpecification SPECIFICATION;
    private NodeId startingNode;
    private RelativePath relativePath;

    public BrowsePath() {
    }

    public BrowsePath(NodeId nodeId, RelativePath relativePath) {
        this.startingNode = nodeId;
        this.relativePath = relativePath;
    }

    public NodeId getStartingNode() {
        return this.startingNode;
    }

    public void setStartingNode(NodeId nodeId) {
        this.startingNode = nodeId;
    }

    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(RelativePath relativePath) {
        this.relativePath = relativePath;
    }

    @Override
    public BrowsePath clone() {
        BrowsePath browsePath = (BrowsePath)super.clone();
        browsePath.startingNode = StructureUtils.clone(this.startingNode);
        browsePath.relativePath = StructureUtils.clone(this.relativePath);
        return browsePath;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowsePath browsePath = (BrowsePath)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStartingNode(), browsePath.getStartingNode())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getRelativePath(), browsePath.getRelativePath());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getStartingNode(), this.getRelativePath());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StartingNode.getSpecification().equals(fieldSpecification)) {
            return this.getStartingNode();
        }
        if (Fields.RelativePath.getSpecification().equals(fieldSpecification)) {
            return this.getRelativePath();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StartingNode.getSpecification().equals(fieldSpecification)) {
            this.setStartingNode((NodeId)object);
            return;
        }
        if (Fields.RelativePath.getSpecification().equals(fieldSpecification)) {
            this.setRelativePath((RelativePath)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = BrowsePath.builder();
        builder.setStartingNode(this.getStartingNode());
        builder.setRelativePath(this.getRelativePath());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.StartingNode.getSpecification());
        builder.addField(Fields.RelativePath.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("BrowsePath");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.BrowsePathSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return BrowsePath.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private NodeId startingNode;
        private RelativePath relativePath;

        protected Builder() {
        }

        public Builder setStartingNode(NodeId nodeId) {
            this.startingNode = nodeId;
            return this;
        }

        public Builder setRelativePath(RelativePath relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StartingNode.getSpecification().equals(fieldSpecification)) {
                this.setStartingNode((NodeId)object);
                return this;
            }
            if (Fields.RelativePath.getSpecification().equals(fieldSpecification)) {
                this.setRelativePath((RelativePath)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public BrowsePath build() {
            return new BrowsePath(this.startingNode, this.relativePath);
        }
    }

    public static enum Fields {
        StartingNode("StartingNode", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        RelativePath("RelativePath", RelativePath.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=540")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

