/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.BrowseResult;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=534")
public class BrowseNextResponse
extends AbstractStructure
implements ServiceResponse {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.BrowseNextResponse_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.BrowseNextResponse_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.BrowseNextResponse_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.BrowseNextResponse;
    public static final StructureSpecification SPECIFICATION;
    private ResponseHeader responseHeader;
    private BrowseResult[] results;
    private DiagnosticInfo[] diagnosticInfos;

    public BrowseNextResponse() {
    }

    public BrowseNextResponse(ResponseHeader responseHeader, BrowseResult[] browseResultArray, DiagnosticInfo[] diagnosticInfoArray) {
        this.responseHeader = responseHeader;
        this.results = browseResultArray;
        this.diagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Override
    public void setResponseHeader(ResponseHeader responseHeader) {
        this.responseHeader = responseHeader;
    }

    public BrowseResult[] getResults() {
        return this.results;
    }

    public void setResults(BrowseResult[] browseResultArray) {
        this.results = browseResultArray;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    public void setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
        this.diagnosticInfos = diagnosticInfoArray;
    }

    @Override
    public BrowseNextResponse clone() {
        BrowseNextResponse browseNextResponse = (BrowseNextResponse)super.clone();
        browseNextResponse.responseHeader = StructureUtils.clone(this.responseHeader);
        browseNextResponse.results = StructureUtils.clone(this.results);
        browseNextResponse.diagnosticInfos = StructureUtils.clone(this.diagnosticInfos);
        return browseNextResponse;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BrowseNextResponse browseNextResponse = (BrowseNextResponse)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getResponseHeader(), browseNextResponse.getResponseHeader())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getResults(), browseNextResponse.getResults())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getDiagnosticInfos(), browseNextResponse.getDiagnosticInfos());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getResponseHeader(), this.getResults(), this.getDiagnosticInfos());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            return this.getResponseHeader();
        }
        if (Fields.Results.getSpecification().equals(fieldSpecification)) {
            return this.getResults();
        }
        if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            return this.getDiagnosticInfos();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
            this.setResponseHeader((ResponseHeader)object);
            return;
        }
        if (Fields.Results.getSpecification().equals(fieldSpecification)) {
            this.setResults((BrowseResult[])object);
            return;
        }
        if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
            this.setDiagnosticInfos((DiagnosticInfo[])object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = BrowseNextResponse.builder();
        builder.setResponseHeader(this.getResponseHeader());
        builder.setResults(this.getResults());
        builder.setDiagnosticInfos(this.getDiagnosticInfos());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.ResponseHeader.getSpecification());
        builder.addField(Fields.Results.getSpecification());
        builder.addField(Fields.DiagnosticInfos.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("BrowseNextResponse");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.BrowseNextResponseSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return BrowseNextResponse.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private ResponseHeader responseHeader;
        private BrowseResult[] results;
        private DiagnosticInfo[] diagnosticInfos;

        protected Builder() {
        }

        public Builder setResponseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return this;
        }

        public Builder setResults(BrowseResult[] browseResultArray) {
            this.results = browseResultArray;
            return this;
        }

        public Builder setDiagnosticInfos(DiagnosticInfo[] diagnosticInfoArray) {
            this.diagnosticInfos = diagnosticInfoArray;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.ResponseHeader.getSpecification().equals(fieldSpecification)) {
                this.setResponseHeader((ResponseHeader)object);
                return this;
            }
            if (Fields.Results.getSpecification().equals(fieldSpecification)) {
                this.setResults((BrowseResult[])object);
                return this;
            }
            if (Fields.DiagnosticInfos.getSpecification().equals(fieldSpecification)) {
                this.setDiagnosticInfos((DiagnosticInfo[])object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public BrowseNextResponse build() {
            return new BrowseNextResponse(this.responseHeader, this.results, this.diagnosticInfos);
        }
    }

    public static enum Fields {
        ResponseHeader("ResponseHeader", ResponseHeader.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=392")), -1),
        Results("Results", BrowseResult[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=522")), 1),
        DiagnosticInfos("DiagnosticInfos", DiagnosticInfo[].class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=25")), 1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

