/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.FilterOperand;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=598")
public class AttributeOperand
extends FilterOperand {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.AttributeOperand_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.AttributeOperand_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.AttributeOperand_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.AttributeOperand;
    public static final StructureSpecification SPECIFICATION;
    private NodeId nodeId;
    private String alias;
    private RelativePath browsePath;
    private UnsignedInteger attributeId;
    private String indexRange;

    public AttributeOperand() {
    }

    public AttributeOperand(NodeId nodeId, String string, RelativePath relativePath, UnsignedInteger unsignedInteger, String string2) {
        this.nodeId = nodeId;
        this.alias = string;
        this.browsePath = relativePath;
        this.attributeId = unsignedInteger;
        this.indexRange = string2;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(NodeId nodeId) {
        this.nodeId = nodeId;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public RelativePath getBrowsePath() {
        return this.browsePath;
    }

    public void setBrowsePath(RelativePath relativePath) {
        this.browsePath = relativePath;
    }

    public UnsignedInteger getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(UnsignedInteger unsignedInteger) {
        this.attributeId = unsignedInteger;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    public void setIndexRange(String string) {
        this.indexRange = string;
    }

    @Override
    public AttributeOperand clone() {
        AttributeOperand attributeOperand = (AttributeOperand)super.clone();
        attributeOperand.nodeId = StructureUtils.clone(this.nodeId);
        attributeOperand.alias = StructureUtils.clone(this.alias);
        attributeOperand.browsePath = StructureUtils.clone(this.browsePath);
        attributeOperand.attributeId = StructureUtils.clone(this.attributeId);
        attributeOperand.indexRange = StructureUtils.clone(this.indexRange);
        return attributeOperand;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AttributeOperand attributeOperand = (AttributeOperand)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getNodeId(), attributeOperand.getNodeId())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getAlias(), attributeOperand.getAlias())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getBrowsePath(), attributeOperand.getBrowsePath())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getAttributeId(), attributeOperand.getAttributeId())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getIndexRange(), attributeOperand.getIndexRange());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getNodeId(), this.getAlias(), this.getBrowsePath(), this.getAttributeId(), this.getIndexRange());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
            return this.getNodeId();
        }
        if (Fields.Alias.getSpecification().equals(fieldSpecification)) {
            return this.getAlias();
        }
        if (Fields.BrowsePath.getSpecification().equals(fieldSpecification)) {
            return this.getBrowsePath();
        }
        if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
            return this.getAttributeId();
        }
        if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
            return this.getIndexRange();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
            this.setNodeId((NodeId)object);
            return;
        }
        if (Fields.Alias.getSpecification().equals(fieldSpecification)) {
            this.setAlias((String)object);
            return;
        }
        if (Fields.BrowsePath.getSpecification().equals(fieldSpecification)) {
            this.setBrowsePath((RelativePath)object);
            return;
        }
        if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
            this.setAttributeId((UnsignedInteger)object);
            return;
        }
        if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
            this.setIndexRange((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = AttributeOperand.builder();
        builder.setNodeId(this.getNodeId());
        builder.setAlias(this.getAlias());
        builder.setBrowsePath(this.getBrowsePath());
        builder.setAttributeId(this.getAttributeId());
        builder.setIndexRange(this.getIndexRange());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.NodeId.getSpecification());
        builder.addField(Fields.Alias.getSpecification());
        builder.addField(Fields.BrowsePath.getSpecification());
        builder.addField(Fields.AttributeId.getSpecification());
        builder.addField(Fields.IndexRange.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("AttributeOperand");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.AttributeOperandSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return AttributeOperand.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends FilterOperand.Builder {
        private NodeId nodeId;
        private String alias;
        private RelativePath browsePath;
        private UnsignedInteger attributeId;
        private String indexRange;

        protected Builder() {
        }

        public Builder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setAlias(String string) {
            this.alias = string;
            return this;
        }

        public Builder setBrowsePath(RelativePath relativePath) {
            this.browsePath = relativePath;
            return this;
        }

        public Builder setAttributeId(UnsignedInteger unsignedInteger) {
            this.attributeId = unsignedInteger;
            return this;
        }

        public Builder setIndexRange(String string) {
            this.indexRange = string;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.NodeId.getSpecification().equals(fieldSpecification)) {
                this.setNodeId((NodeId)object);
                return this;
            }
            if (Fields.Alias.getSpecification().equals(fieldSpecification)) {
                this.setAlias((String)object);
                return this;
            }
            if (Fields.BrowsePath.getSpecification().equals(fieldSpecification)) {
                this.setBrowsePath((RelativePath)object);
                return this;
            }
            if (Fields.AttributeId.getSpecification().equals(fieldSpecification)) {
                this.setAttributeId((UnsignedInteger)object);
                return this;
            }
            if (Fields.IndexRange.getSpecification().equals(fieldSpecification)) {
                this.setIndexRange((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public AttributeOperand build() {
            return new AttributeOperand(this.nodeId, this.alias, this.browsePath, this.attributeId, this.indexRange);
        }
    }

    public static enum Fields {
        NodeId("NodeId", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        Alias("Alias", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1),
        BrowsePath("BrowsePath", RelativePath.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=540")), -1),
        AttributeId("AttributeId", UnsignedInteger.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=288")), -1),
        IndexRange("IndexRange", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=291")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

