/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=319")
public class AnonymousIdentityToken
extends UserIdentityToken {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.AnonymousIdentityToken_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.AnonymousIdentityToken_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.AnonymousIdentityToken_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.AnonymousIdentityToken;
    public static final StructureSpecification SPECIFICATION;

    public AnonymousIdentityToken() {
    }

    public AnonymousIdentityToken(String string) {
        super(string);
    }

    @Override
    public AnonymousIdentityToken clone() {
        AnonymousIdentityToken anonymousIdentityToken = (AnonymousIdentityToken)super.clone();
        return anonymousIdentityToken;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AnonymousIdentityToken anonymousIdentityToken = (AnonymousIdentityToken)object;
        return StructureUtils.scalarOrArrayEquals(this.getPolicyId(), anonymousIdentityToken.getPolicyId());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getPolicyId());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
            return this.getPolicyId();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
            this.setPolicyId((String)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = AnonymousIdentityToken.builder();
        builder.setPolicyId(this.getPolicyId());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.PolicyId.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("AnonymousIdentityToken");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.AnonymousIdentityTokenSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return AnonymousIdentityToken.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends UserIdentityToken.Builder {
        private String policyId;

        protected Builder() {
        }

        @Override
        public Builder setPolicyId(String string) {
            this.policyId = string;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.PolicyId.getSpecification().equals(fieldSpecification)) {
                this.setPolicyId((String)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public AnonymousIdentityToken build() {
            return new AnonymousIdentityToken(this.policyId);
        }
    }

    public static enum Fields {
        PolicyId("PolicyId", String.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=12")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

