/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.AggregateConfiguration;
import com.prosysopc.ua.stack.core.MonitoringFilterResult;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=737")
public class AggregateFilterResult
extends MonitoringFilterResult {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.AggregateFilterResult_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.AggregateFilterResult_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.AggregateFilterResult_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.AggregateFilterResult;
    public static final StructureSpecification SPECIFICATION;
    private DateTime revisedStartTime;
    private Double revisedProcessingInterval;
    private AggregateConfiguration revisedAggregateConfiguration;

    public AggregateFilterResult() {
    }

    public AggregateFilterResult(DateTime dateTime, Double d2, AggregateConfiguration aggregateConfiguration) {
        this.revisedStartTime = dateTime;
        this.revisedProcessingInterval = d2;
        this.revisedAggregateConfiguration = aggregateConfiguration;
    }

    public DateTime getRevisedStartTime() {
        return this.revisedStartTime;
    }

    public void setRevisedStartTime(DateTime dateTime) {
        this.revisedStartTime = dateTime;
    }

    public Double getRevisedProcessingInterval() {
        return this.revisedProcessingInterval;
    }

    public void setRevisedProcessingInterval(Double d2) {
        this.revisedProcessingInterval = d2;
    }

    public AggregateConfiguration getRevisedAggregateConfiguration() {
        return this.revisedAggregateConfiguration;
    }

    public void setRevisedAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
        this.revisedAggregateConfiguration = aggregateConfiguration;
    }

    @Override
    public AggregateFilterResult clone() {
        AggregateFilterResult aggregateFilterResult = (AggregateFilterResult)super.clone();
        aggregateFilterResult.revisedStartTime = StructureUtils.clone(this.revisedStartTime);
        aggregateFilterResult.revisedProcessingInterval = StructureUtils.clone(this.revisedProcessingInterval);
        aggregateFilterResult.revisedAggregateConfiguration = StructureUtils.clone(this.revisedAggregateConfiguration);
        return aggregateFilterResult;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AggregateFilterResult aggregateFilterResult = (AggregateFilterResult)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getRevisedStartTime(), aggregateFilterResult.getRevisedStartTime())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getRevisedProcessingInterval(), aggregateFilterResult.getRevisedProcessingInterval())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getRevisedAggregateConfiguration(), aggregateFilterResult.getRevisedAggregateConfiguration());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getRevisedStartTime(), this.getRevisedProcessingInterval(), this.getRevisedAggregateConfiguration());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.RevisedStartTime.getSpecification().equals(fieldSpecification)) {
            return this.getRevisedStartTime();
        }
        if (Fields.RevisedProcessingInterval.getSpecification().equals(fieldSpecification)) {
            return this.getRevisedProcessingInterval();
        }
        if (Fields.RevisedAggregateConfiguration.getSpecification().equals(fieldSpecification)) {
            return this.getRevisedAggregateConfiguration();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.RevisedStartTime.getSpecification().equals(fieldSpecification)) {
            this.setRevisedStartTime((DateTime)object);
            return;
        }
        if (Fields.RevisedProcessingInterval.getSpecification().equals(fieldSpecification)) {
            this.setRevisedProcessingInterval((Double)object);
            return;
        }
        if (Fields.RevisedAggregateConfiguration.getSpecification().equals(fieldSpecification)) {
            this.setRevisedAggregateConfiguration((AggregateConfiguration)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = AggregateFilterResult.builder();
        builder.setRevisedStartTime(this.getRevisedStartTime());
        builder.setRevisedProcessingInterval(this.getRevisedProcessingInterval());
        builder.setRevisedAggregateConfiguration(this.getRevisedAggregateConfiguration());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.RevisedStartTime.getSpecification());
        builder.addField(Fields.RevisedProcessingInterval.getSpecification());
        builder.addField(Fields.RevisedAggregateConfiguration.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("AggregateFilterResult");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.AggregateFilterResultSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return AggregateFilterResult.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends MonitoringFilterResult.Builder {
        private DateTime revisedStartTime;
        private Double revisedProcessingInterval;
        private AggregateConfiguration revisedAggregateConfiguration;

        protected Builder() {
        }

        public Builder setRevisedStartTime(DateTime dateTime) {
            this.revisedStartTime = dateTime;
            return this;
        }

        public Builder setRevisedProcessingInterval(Double d2) {
            this.revisedProcessingInterval = d2;
            return this;
        }

        public Builder setRevisedAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
            this.revisedAggregateConfiguration = aggregateConfiguration;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.RevisedStartTime.getSpecification().equals(fieldSpecification)) {
                this.setRevisedStartTime((DateTime)object);
                return this;
            }
            if (Fields.RevisedProcessingInterval.getSpecification().equals(fieldSpecification)) {
                this.setRevisedProcessingInterval((Double)object);
                return this;
            }
            if (Fields.RevisedAggregateConfiguration.getSpecification().equals(fieldSpecification)) {
                this.setRevisedAggregateConfiguration((AggregateConfiguration)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public AggregateFilterResult build() {
            return new AggregateFilterResult(this.revisedStartTime, this.revisedProcessingInterval, this.revisedAggregateConfiguration);
        }
    }

    public static enum Fields {
        RevisedStartTime("RevisedStartTime", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1),
        RevisedProcessingInterval("RevisedProcessingInterval", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=290")), -1),
        RevisedAggregateConfiguration("RevisedAggregateConfiguration", AggregateConfiguration.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=948")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

