/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.AggregateConfiguration;
import com.prosysopc.ua.stack.core.MonitoringFilter;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=728")
public class AggregateFilter
extends MonitoringFilter {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.AggregateFilter_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.AggregateFilter_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.AggregateFilter_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.AggregateFilter;
    public static final StructureSpecification SPECIFICATION;
    private DateTime startTime;
    private NodeId aggregateType;
    private Double processingInterval;
    private AggregateConfiguration aggregateConfiguration;

    public AggregateFilter() {
    }

    public AggregateFilter(DateTime dateTime, NodeId nodeId, Double d2, AggregateConfiguration aggregateConfiguration) {
        this.startTime = dateTime;
        this.aggregateType = nodeId;
        this.processingInterval = d2;
        this.aggregateConfiguration = aggregateConfiguration;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(DateTime dateTime) {
        this.startTime = dateTime;
    }

    public NodeId getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(NodeId nodeId) {
        this.aggregateType = nodeId;
    }

    public Double getProcessingInterval() {
        return this.processingInterval;
    }

    public void setProcessingInterval(Double d2) {
        this.processingInterval = d2;
    }

    public AggregateConfiguration getAggregateConfiguration() {
        return this.aggregateConfiguration;
    }

    public void setAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
        this.aggregateConfiguration = aggregateConfiguration;
    }

    @Override
    public AggregateFilter clone() {
        AggregateFilter aggregateFilter = (AggregateFilter)super.clone();
        aggregateFilter.startTime = StructureUtils.clone(this.startTime);
        aggregateFilter.aggregateType = StructureUtils.clone(this.aggregateType);
        aggregateFilter.processingInterval = StructureUtils.clone(this.processingInterval);
        aggregateFilter.aggregateConfiguration = StructureUtils.clone(this.aggregateConfiguration);
        return aggregateFilter;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AggregateFilter aggregateFilter = (AggregateFilter)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getStartTime(), aggregateFilter.getStartTime())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getAggregateType(), aggregateFilter.getAggregateType())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getProcessingInterval(), aggregateFilter.getProcessingInterval())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getAggregateConfiguration(), aggregateFilter.getAggregateConfiguration());
    }

    @Override
    public int hashCode() {
        return StructureUtils.hashCode(this.getStartTime(), this.getAggregateType(), this.getProcessingInterval(), this.getAggregateConfiguration());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.StartTime.getSpecification().equals(fieldSpecification)) {
            return this.getStartTime();
        }
        if (Fields.AggregateType.getSpecification().equals(fieldSpecification)) {
            return this.getAggregateType();
        }
        if (Fields.ProcessingInterval.getSpecification().equals(fieldSpecification)) {
            return this.getProcessingInterval();
        }
        if (Fields.AggregateConfiguration.getSpecification().equals(fieldSpecification)) {
            return this.getAggregateConfiguration();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.StartTime.getSpecification().equals(fieldSpecification)) {
            this.setStartTime((DateTime)object);
            return;
        }
        if (Fields.AggregateType.getSpecification().equals(fieldSpecification)) {
            this.setAggregateType((NodeId)object);
            return;
        }
        if (Fields.ProcessingInterval.getSpecification().equals(fieldSpecification)) {
            this.setProcessingInterval((Double)object);
            return;
        }
        if (Fields.AggregateConfiguration.getSpecification().equals(fieldSpecification)) {
            this.setAggregateConfiguration((AggregateConfiguration)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = AggregateFilter.builder();
        builder.setStartTime(this.getStartTime());
        builder.setAggregateType(this.getAggregateType());
        builder.setProcessingInterval(this.getProcessingInterval());
        builder.setAggregateConfiguration(this.getAggregateConfiguration());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.StartTime.getSpecification());
        builder.addField(Fields.AggregateType.getSpecification());
        builder.addField(Fields.ProcessingInterval.getSpecification());
        builder.addField(Fields.AggregateConfiguration.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("AggregateFilter");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.AggregateFilterSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return AggregateFilter.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends MonitoringFilter.Builder {
        private DateTime startTime;
        private NodeId aggregateType;
        private Double processingInterval;
        private AggregateConfiguration aggregateConfiguration;

        protected Builder() {
        }

        public Builder setStartTime(DateTime dateTime) {
            this.startTime = dateTime;
            return this;
        }

        public Builder setAggregateType(NodeId nodeId) {
            this.aggregateType = nodeId;
            return this;
        }

        public Builder setProcessingInterval(Double d2) {
            this.processingInterval = d2;
            return this;
        }

        public Builder setAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
            this.aggregateConfiguration = aggregateConfiguration;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.StartTime.getSpecification().equals(fieldSpecification)) {
                this.setStartTime((DateTime)object);
                return this;
            }
            if (Fields.AggregateType.getSpecification().equals(fieldSpecification)) {
                this.setAggregateType((NodeId)object);
                return this;
            }
            if (Fields.ProcessingInterval.getSpecification().equals(fieldSpecification)) {
                this.setProcessingInterval((Double)object);
                return this;
            }
            if (Fields.AggregateConfiguration.getSpecification().equals(fieldSpecification)) {
                this.setAggregateConfiguration((AggregateConfiguration)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public AggregateFilter build() {
            return new AggregateFilter(this.startTime, this.aggregateType, this.processingInterval, this.aggregateConfiguration);
        }
    }

    public static enum Fields {
        StartTime("StartTime", DateTime.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=294")), -1),
        AggregateType("AggregateType", NodeId.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=17")), -1),
        ProcessingInterval("ProcessingInterval", Double.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=290")), -1),
        AggregateConfiguration("AggregateConfiguration", AggregateConfiguration.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=948")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

