/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.StructureSerializer;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.types.opcua.Ids;
import com.prosysopc.ua.types.opcua.Serializers;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=948")
public class AggregateConfiguration
extends AbstractStructure {
    @Deprecated
    public static final ExpandedNodeId BINARY = Ids.AggregateConfiguration_DefaultBinary;
    @Deprecated
    public static final ExpandedNodeId XML = Ids.AggregateConfiguration_DefaultXml;
    @Deprecated
    public static final ExpandedNodeId JSON = Ids.AggregateConfiguration_DefaultJson;
    @Deprecated
    public static final ExpandedNodeId ID = Ids.AggregateConfiguration;
    public static final StructureSpecification SPECIFICATION;
    private Boolean useServerCapabilitiesDefaults;
    private Boolean treatUncertainAsBad;
    private UnsignedByte percentDataBad;
    private UnsignedByte percentDataGood;
    private Boolean useSlopedExtrapolation;

    public AggregateConfiguration() {
    }

    public AggregateConfiguration(Boolean bl, Boolean bl2, UnsignedByte unsignedByte, UnsignedByte unsignedByte2, Boolean bl3) {
        this.useServerCapabilitiesDefaults = bl;
        this.treatUncertainAsBad = bl2;
        this.percentDataBad = unsignedByte;
        this.percentDataGood = unsignedByte2;
        this.useSlopedExtrapolation = bl3;
    }

    public Boolean getUseServerCapabilitiesDefaults() {
        return this.useServerCapabilitiesDefaults;
    }

    public void setUseServerCapabilitiesDefaults(Boolean bl) {
        this.useServerCapabilitiesDefaults = bl;
    }

    public Boolean getTreatUncertainAsBad() {
        return this.treatUncertainAsBad;
    }

    public void setTreatUncertainAsBad(Boolean bl) {
        this.treatUncertainAsBad = bl;
    }

    public UnsignedByte getPercentDataBad() {
        return this.percentDataBad;
    }

    public void setPercentDataBad(UnsignedByte unsignedByte) {
        this.percentDataBad = unsignedByte;
    }

    public UnsignedByte getPercentDataGood() {
        return this.percentDataGood;
    }

    public void setPercentDataGood(UnsignedByte unsignedByte) {
        this.percentDataGood = unsignedByte;
    }

    public Boolean getUseSlopedExtrapolation() {
        return this.useSlopedExtrapolation;
    }

    public void setUseSlopedExtrapolation(Boolean bl) {
        this.useSlopedExtrapolation = bl;
    }

    @Override
    public AggregateConfiguration clone() {
        AggregateConfiguration aggregateConfiguration = (AggregateConfiguration)super.clone();
        aggregateConfiguration.useServerCapabilitiesDefaults = StructureUtils.clone(this.useServerCapabilitiesDefaults);
        aggregateConfiguration.treatUncertainAsBad = StructureUtils.clone(this.treatUncertainAsBad);
        aggregateConfiguration.percentDataBad = StructureUtils.clone(this.percentDataBad);
        aggregateConfiguration.percentDataGood = StructureUtils.clone(this.percentDataGood);
        aggregateConfiguration.useSlopedExtrapolation = StructureUtils.clone(this.useSlopedExtrapolation);
        return aggregateConfiguration;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AggregateConfiguration aggregateConfiguration = (AggregateConfiguration)object;
        if (!StructureUtils.scalarOrArrayEquals(this.getUseServerCapabilitiesDefaults(), aggregateConfiguration.getUseServerCapabilitiesDefaults())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getTreatUncertainAsBad(), aggregateConfiguration.getTreatUncertainAsBad())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getPercentDataBad(), aggregateConfiguration.getPercentDataBad())) {
            return false;
        }
        if (!StructureUtils.scalarOrArrayEquals(this.getPercentDataGood(), aggregateConfiguration.getPercentDataGood())) {
            return false;
        }
        return StructureUtils.scalarOrArrayEquals(this.getUseSlopedExtrapolation(), aggregateConfiguration.getUseSlopedExtrapolation());
    }

    public int hashCode() {
        return StructureUtils.hashCode(this.getUseServerCapabilitiesDefaults(), this.getTreatUncertainAsBad(), this.getPercentDataBad(), this.getPercentDataGood(), this.getUseSlopedExtrapolation());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        return BINARY;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        return XML;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getJsonEncodeId() {
        return JSON;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return ID;
    }

    @Override
    public StructureSpecification specification() {
        return SPECIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        if (Fields.UseServerCapabilitiesDefaults.getSpecification().equals(fieldSpecification)) {
            return this.getUseServerCapabilitiesDefaults();
        }
        if (Fields.TreatUncertainAsBad.getSpecification().equals(fieldSpecification)) {
            return this.getTreatUncertainAsBad();
        }
        if (Fields.PercentDataBad.getSpecification().equals(fieldSpecification)) {
            return this.getPercentDataBad();
        }
        if (Fields.PercentDataGood.getSpecification().equals(fieldSpecification)) {
            return this.getPercentDataGood();
        }
        if (Fields.UseSlopedExtrapolation.getSpecification().equals(fieldSpecification)) {
            return this.getUseSlopedExtrapolation();
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        if (Fields.UseServerCapabilitiesDefaults.getSpecification().equals(fieldSpecification)) {
            this.setUseServerCapabilitiesDefaults((Boolean)object);
            return;
        }
        if (Fields.TreatUncertainAsBad.getSpecification().equals(fieldSpecification)) {
            this.setTreatUncertainAsBad((Boolean)object);
            return;
        }
        if (Fields.PercentDataBad.getSpecification().equals(fieldSpecification)) {
            this.setPercentDataBad((UnsignedByte)object);
            return;
        }
        if (Fields.PercentDataGood.getSpecification().equals(fieldSpecification)) {
            this.setPercentDataGood((UnsignedByte)object);
            return;
        }
        if (Fields.UseSlopedExtrapolation.getSpecification().equals(fieldSpecification)) {
            this.setUseSlopedExtrapolation((Boolean)object);
            return;
        }
        throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = AggregateConfiguration.builder();
        builder.setUseServerCapabilitiesDefaults(this.getUseServerCapabilitiesDefaults());
        builder.setTreatUncertainAsBad(this.getTreatUncertainAsBad());
        builder.setPercentDataBad(this.getPercentDataBad());
        builder.setPercentDataGood(this.getPercentDataGood());
        builder.setUseSlopedExtrapolation(this.getUseSlopedExtrapolation());
        return builder;
    }

    static {
        StructureSpecification.Builder builder = StructureSpecification.builder();
        builder.addField(Fields.UseServerCapabilitiesDefaults.getSpecification());
        builder.addField(Fields.TreatUncertainAsBad.getSpecification());
        builder.addField(Fields.PercentDataBad.getSpecification());
        builder.addField(Fields.PercentDataGood.getSpecification());
        builder.addField(Fields.UseSlopedExtrapolation.getSpecification());
        builder.setBinaryEncodeId(UaNodeId.fromLocal(BINARY));
        builder.setXmlEncodeId(UaNodeId.fromLocal(XML));
        builder.setJsonEncodeId(UaNodeId.fromLocal(JSON));
        builder.setTypeId(UaNodeId.fromLocal(ID));
        builder.setName("AggregateConfiguration");
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setSerializerSupplier(new StructureSpecification.StructureSerializerSupplier(){

            @Override
            public StructureSerializer get(StructureSpecification structureSpecification, EncoderContext encoderContext) {
                return new Serializers.AggregateConfigurationSerializer();
            }
        });
        builder.setBuilderSupplier(new StructureSpecification.StructureBuilderSupplier(){

            @Override
            public Structure.Builder get() {
                return AggregateConfiguration.builder();
            }
        });
        SPECIFICATION = builder.build();
    }

    public static class Builder
    extends AbstractStructure.Builder {
        private Boolean useServerCapabilitiesDefaults;
        private Boolean treatUncertainAsBad;
        private UnsignedByte percentDataBad;
        private UnsignedByte percentDataGood;
        private Boolean useSlopedExtrapolation;

        protected Builder() {
        }

        public Builder setUseServerCapabilitiesDefaults(Boolean bl) {
            this.useServerCapabilitiesDefaults = bl;
            return this;
        }

        public Builder setTreatUncertainAsBad(Boolean bl) {
            this.treatUncertainAsBad = bl;
            return this;
        }

        public Builder setPercentDataBad(UnsignedByte unsignedByte) {
            this.percentDataBad = unsignedByte;
            return this;
        }

        public Builder setPercentDataGood(UnsignedByte unsignedByte) {
            this.percentDataGood = unsignedByte;
            return this;
        }

        public Builder setUseSlopedExtrapolation(Boolean bl) {
            this.useSlopedExtrapolation = bl;
            return this;
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            if (Fields.UseServerCapabilitiesDefaults.getSpecification().equals(fieldSpecification)) {
                this.setUseServerCapabilitiesDefaults((Boolean)object);
                return this;
            }
            if (Fields.TreatUncertainAsBad.getSpecification().equals(fieldSpecification)) {
                this.setTreatUncertainAsBad((Boolean)object);
                return this;
            }
            if (Fields.PercentDataBad.getSpecification().equals(fieldSpecification)) {
                this.setPercentDataBad((UnsignedByte)object);
                return this;
            }
            if (Fields.PercentDataGood.getSpecification().equals(fieldSpecification)) {
                this.setPercentDataGood((UnsignedByte)object);
                return this;
            }
            if (Fields.UseSlopedExtrapolation.getSpecification().equals(fieldSpecification)) {
                this.setUseSlopedExtrapolation((Boolean)object);
                return this;
            }
            throw new IllegalArgumentException("Unknown field: " + fieldSpecification);
        }

        @Override
        public AggregateConfiguration build() {
            return new AggregateConfiguration(this.useServerCapabilitiesDefaults, this.treatUncertainAsBad, this.percentDataBad, this.percentDataGood, this.useSlopedExtrapolation);
        }
    }

    public static enum Fields {
        UseServerCapabilitiesDefaults("UseServerCapabilitiesDefaults", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1),
        TreatUncertainAsBad("TreatUncertainAsBad", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1),
        PercentDataBad("PercentDataBad", UnsignedByte.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=3")), -1),
        PercentDataGood("PercentDataGood", UnsignedByte.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=3")), -1),
        UseSlopedExtrapolation("UseSlopedExtrapolation", Boolean.class, false, UaNodeId.fromLocal(ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=1")), -1);

        private final FieldSpecification value;

        private Fields(String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n3) {
            FieldSpecification.Builder builder = FieldSpecification.builder();
            builder.setName(string2);
            builder.setJavaClass(clazz);
            builder.setIsOptional(bl);
            builder.setDataTypeId(uaNodeId);
            builder.setValueRank(n3);
            this.value = builder.build();
        }

        public FieldSpecification getSpecification() {
            return this.value;
        }
    }
}

