/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.common;

import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.common.UriTable;

public class NamespaceTable
extends UriTable {
    public static String OPCUA_NAMESPACE = "http://opcfoundation.org/UA/";
    static String pA = "invalid_missing_namespacearray_uri_for_index:";
    private static NamespaceTable pB;

    public static NamespaceTable createFromArray(String[] stringArray) {
        NamespaceTable namespaceTable = new NamespaceTable();
        namespaceTable.addAll(stringArray);
        return namespaceTable;
    }

    public static NamespaceTable getDefaultInstance() {
        if (pB == null) {
            pB = NamespaceTable.createFromArray(new String[]{OPCUA_NAMESPACE});
        }
        return pB;
    }

    public NamespaceTable() {
        this.add(0, OPCUA_NAMESPACE);
    }

    public boolean namespaceEquals(ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2) {
        int n2;
        int n3 = expandedNodeId.getNamespaceUri() != null ? this.r(expandedNodeId.getNamespaceUri()) : expandedNodeId.getNamespaceIndex();
        int n4 = n2 = expandedNodeId2.getNamespaceUri() != null ? this.r(expandedNodeId2.getNamespaceUri()) : expandedNodeId2.getNamespaceIndex();
        if (n3 < 0 || n2 < 0) {
            return false;
        }
        return n3 == n2;
    }

    public boolean namespaceEquals(NodeId nodeId, ExpandedNodeId expandedNodeId) {
        int n2;
        int n3 = n2 = expandedNodeId.getNamespaceUri() != null ? this.r(expandedNodeId.getNamespaceUri()) : expandedNodeId.getNamespaceIndex();
        if (n2 < 0) {
            return false;
        }
        return nodeId.getNamespaceIndex() == n2;
    }

    public boolean namespaceEquals(NodeId nodeId, NodeId nodeId2) {
        return nodeId.getNamespaceIndex() == nodeId2.getNamespaceIndex();
    }

    public boolean nodeIdEquals(ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2) {
        int n2;
        if (ExpandedNodeId.isNull(expandedNodeId) && ExpandedNodeId.isNull(expandedNodeId2)) {
            return true;
        }
        if (ExpandedNodeId.isNull(expandedNodeId) || ExpandedNodeId.isNull(expandedNodeId2)) {
            return false;
        }
        if (!expandedNodeId.getValue().equals(expandedNodeId2.getValue())) {
            return false;
        }
        int n3 = expandedNodeId.getNamespaceUri() == null ? expandedNodeId.getNamespaceIndex() : this.r(expandedNodeId.getNamespaceUri());
        int n4 = n2 = expandedNodeId2.getNamespaceUri() == null ? expandedNodeId2.getNamespaceIndex() : this.r(expandedNodeId2.getNamespaceUri());
        if (n3 < 0 || n2 < 0) {
            return false;
        }
        return n3 == n2;
    }

    public boolean nodeIdEquals(NodeId nodeId, ExpandedNodeId expandedNodeId) {
        int n2;
        if (NodeId.isNull(nodeId) && ExpandedNodeId.isNull(expandedNodeId)) {
            return true;
        }
        if (NodeId.isNull(nodeId) || ExpandedNodeId.isNull(expandedNodeId)) {
            return false;
        }
        if (!nodeId.getValue().equals(expandedNodeId.getValue())) {
            return false;
        }
        int n3 = nodeId.getNamespaceIndex();
        int n4 = n2 = expandedNodeId.getNamespaceUri() == null ? expandedNodeId.getNamespaceIndex() : this.r(expandedNodeId.getNamespaceUri());
        if (n3 < 0 || n2 < 0) {
            return false;
        }
        return n3 == n2;
    }

    public ExpandedNodeId toExpandedNodeId(NodeId nodeId) {
        return new ExpandedNodeId(null, this.d(nodeId.getNamespaceIndex()), nodeId.getValue());
    }

    public NodeId toNodeId(ExpandedNodeId expandedNodeId) throws ServiceResultException {
        if (ExpandedNodeId.isNull(expandedNodeId)) {
            return NodeId.NULL;
        }
        if (!expandedNodeId.isLocal()) {
            throw new ServiceResultException("Cannot convert ExpandedNodeId with server index to NodeId");
        }
        String string = expandedNodeId.getNamespaceUri();
        if (string == null) {
            return NodeId.get(expandedNodeId.getIdType(), expandedNodeId.getNamespaceIndex(), expandedNodeId.getValue());
        }
        return NodeId.get(expandedNodeId.getIdType(), this.q(string), expandedNodeId.getValue());
    }

    int q(String string) throws ServiceResultException {
        int n2 = this.getIndex(string);
        if (n2 < 0) {
            if (string.startsWith(pA)) {
                try {
                    n2 = Integer.parseInt(string.substring(pA.length()));
                }
                catch (Exception exception) {
                    throw new ServiceResultException("Index for uri \"" + string + "\" not found in NamespaceTable and 'invalid pattern' workaround cannot be applied");
                }
            } else {
                throw new ServiceResultException("Index for uri \"" + string + "\" not found in NamespaceTable");
            }
        }
        return n2;
    }

    int r(String string) {
        int n2 = this.getIndex(string);
        if (n2 < 0) {
            if (string.startsWith(pA)) {
                try {
                    n2 = Integer.parseInt(string.substring(pA.length()));
                }
                catch (Exception exception) {
                    return -1;
                }
            } else {
                return -1;
            }
        }
        return n2;
    }

    String d(int n2) {
        String string = this.getUri(n2);
        if (string == null) {
            string = pA + n2;
        }
        return string;
    }
}

